@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Sku of Azure Spring Apps
 * @property capacity Current capacity of the target resource
 * @property name Name of the Sku
 * @property tier Tier of the Sku
 */
public data class SkuArgs(
    public val capacity: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.SkuArgs =
        com.pulumi.azurenative.appplatform.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var name: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value Current capacity of the target resource
     */
    @JvmName("odygnnqrfnbefcpf")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value Name of the Sku
     */
    @JvmName("pjdusvwnhgedvwwg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Tier of the Sku
     */
    @JvmName("duaahmvilpfvmhdd")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Current capacity of the target resource
     */
    @JvmName("pjprcpmyoumnvebg")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value Name of the Sku
     */
    @JvmName("ibvxifhhlogffooo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Tier of the Sku
     */
    @JvmName("uqqefelrlvmxkdjd")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        name = name,
        tier = tier,
    )
}
