@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.inputs

import com.pulumi.azurenative.appplatform.inputs.StorageAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * storage resource of type Azure Storage Account.
 * @property accountKey The account key of the Azure Storage Account.
 * @property accountName The account name of the Azure Storage Account.
 * @property storageType The type of the storage.
 * Expected value is 'StorageAccount'.
 */
public data class StorageAccountArgs(
    public val accountKey: Output<String>,
    public val accountName: Output<String>,
    public val storageType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.appplatform.inputs.StorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.appplatform.inputs.StorageAccountArgs =
        com.pulumi.azurenative.appplatform.inputs.StorageAccountArgs.builder()
            .accountKey(accountKey.applyValue({ args0 -> args0 }))
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .storageType(storageType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageAccountArgs].
 */
@PulumiTagMarker
public class StorageAccountArgsBuilder internal constructor() {
    private var accountKey: Output<String>? = null

    private var accountName: Output<String>? = null

    private var storageType: Output<String>? = null

    /**
     * @param value The account key of the Azure Storage Account.
     */
    @JvmName("ccxdfprrjcxeauyy")
    public suspend fun accountKey(`value`: Output<String>) {
        this.accountKey = value
    }

    /**
     * @param value The account name of the Azure Storage Account.
     */
    @JvmName("lavpbsvhnmiauwdj")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The type of the storage.
     * Expected value is 'StorageAccount'.
     */
    @JvmName("fqhkjjpcjoygmgyc")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value The account key of the Azure Storage Account.
     */
    @JvmName("vhpridrklcedgsqp")
    public suspend fun accountKey(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountKey = mapped
    }

    /**
     * @param value The account name of the Azure Storage Account.
     */
    @JvmName("nqtalhboyxelxraj")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The type of the storage.
     * Expected value is 'StorageAccount'.
     */
    @JvmName("byklsysoutomtaqr")
    public suspend fun storageType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    internal fun build(): StorageAccountArgs = StorageAccountArgs(
        accountKey = accountKey ?: throw PulumiNullFieldException("accountKey"),
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        storageType = storageType ?: throw PulumiNullFieldException("storageType"),
    )
}
