@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * API portal properties payload
 * @property gatewayIds The array of resource Ids of gateway to integrate with API portal.
 * @property httpsOnly Indicate if only https is allowed.
 * @property instances Collection of instances belong to API portal.
 * @property provisioningState State of the API portal.
 * @property public Indicates whether the API portal exposes endpoint.
 * @property resourceRequests The requested resource quantity for required CPU and Memory.
 * @property sourceUrls Collection of OpenAPI source URL locations.
 * @property ssoProperties Single sign-on related configuration
 * @property url URL of the API portal, exposed when 'public' is true.
 */
public data class ApiPortalPropertiesResponse(
    public val gatewayIds: List<String>? = null,
    public val httpsOnly: Boolean? = null,
    public val instances: List<ApiPortalInstanceResponse>,
    public val provisioningState: String,
    public val `public`: Boolean? = null,
    public val resourceRequests: ApiPortalResourceRequestsResponse,
    public val sourceUrls: List<String>? = null,
    public val ssoProperties: SsoPropertiesResponse? = null,
    public val url: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ApiPortalPropertiesResponse):
            ApiPortalPropertiesResponse = ApiPortalPropertiesResponse(
            gatewayIds = javaType.gatewayIds().map({ args0 -> args0 }),
            httpsOnly = javaType.httpsOnly().map({ args0 -> args0 }).orElse(null),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ApiPortalInstanceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            `public` = javaType.public_().map({ args0 -> args0 }).orElse(null),
            resourceRequests = javaType.resourceRequests().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.ApiPortalResourceRequestsResponse.Companion.toKotlin(args0)
            }),
            sourceUrls = javaType.sourceUrls().map({ args0 -> args0 }),
            ssoProperties = javaType.ssoProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.SsoPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            url = javaType.url(),
        )
    }
}
