@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Properties of an APM
 * @property properties Non-sensitive properties for the APM
 * @property provisioningState State of the APM.
 * @property type APM Type
 */
public data class ApmPropertiesResponse(
    public val properties: Map<String, String>? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ApmPropertiesResponse):
            ApmPropertiesResponse = ApmPropertiesResponse(
            properties = javaType.properties().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
