@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Name of the Application Accelerator instance.
 * @property status Status of the Application Accelerator instance. It can be Pending, Running, Succeeded, Failed, Unknown.
 */
public data class ApplicationAcceleratorInstanceResponse(
    public val name: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ApplicationAcceleratorInstanceResponse):
            ApplicationAcceleratorInstanceResponse = ApplicationAcceleratorInstanceResponse(
            name = javaType.name(),
            status = javaType.status(),
        )
    }
}
