@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Build resource properties payload
 * @property agentPool The resource id of agent pool
 * @property apms The APMs for this build
 * @property builder The resource id of builder to build the source code
 * @property certificates The CA Certificates for this build
 * @property env The environment variables for this build
 * @property provisioningState Provisioning state of the KPack build result
 * @property relativePath The relative path of source code
 * @property resourceRequests The customized build resource for this build
 * @property triggeredBuildResult  The build result triggered by this build
 */
public data class BuildPropertiesResponse(
    public val agentPool: String? = null,
    public val apms: List<ApmReferenceResponse>? = null,
    public val builder: String? = null,
    public val certificates: List<CertificateReferenceResponse>? = null,
    public val env: Map<String, String>? = null,
    public val provisioningState: String,
    public val relativePath: String? = null,
    public val resourceRequests: BuildResourceRequestsResponse? = null,
    public val triggeredBuildResult: TriggeredBuildResultResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.BuildPropertiesResponse):
            BuildPropertiesResponse = BuildPropertiesResponse(
            agentPool = javaType.agentPool().map({ args0 -> args0 }).orElse(null),
            apms = javaType.apms().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.ApmReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            builder = javaType.builder_().map({ args0 -> args0 }).orElse(null),
            certificates = javaType.certificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.CertificateReferenceResponse.Companion.toKotlin(args0)
                })
            }),
            env = javaType.env().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            provisioningState = javaType.provisioningState(),
            relativePath = javaType.relativePath().map({ args0 -> args0 }).orElse(null),
            resourceRequests = javaType.resourceRequests().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.BuildResourceRequestsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            triggeredBuildResult = javaType.triggeredBuildResult().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.TriggeredBuildResultResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
