@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of a buildpack binding
 * @property bindingType Buildpack Binding Type
 * @property launchProperties The object describes the buildpack binding launch properties
 * @property provisioningState State of the Buildpack Binding.
 */
public data class BuildpackBindingPropertiesResponse(
    public val bindingType: String? = null,
    public val launchProperties: BuildpackBindingLaunchPropertiesResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.BuildpackBindingPropertiesResponse):
            BuildpackBindingPropertiesResponse = BuildpackBindingPropertiesResponse(
            bindingType = javaType.bindingType().map({ args0 -> args0 }).orElse(null),
            launchProperties = javaType.launchProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.BuildpackBindingLaunchPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
