@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Custom container user source info
 * @property customContainer Custom container payload
 * @property type Type of the source uploaded
 * Expected value is 'Container'.
 * @property version Version of the source
 */
public data class CustomContainerUserSourceInfoResponse(
    public val customContainer: CustomContainerResponse? = null,
    public val type: String,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.CustomContainerUserSourceInfoResponse):
            CustomContainerUserSourceInfoResponse = CustomContainerUserSourceInfoResponse(
            customContainer = javaType.customContainer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.CustomContainerResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
