@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Dev Tool Portal properties payload
 * @property components Collection of components belong to Dev Tool Portal.
 * @property features Settings for Dev Tool Portal
 * @property provisioningState State of the Dev Tool Portal.
 * @property public Indicates whether the resource exposes public endpoint
 * @property ssoProperties Single sign-on related configuration
 * @property url URL of the resource, exposed when 'public' is true.
 */
public data class DevToolPortalPropertiesResponse(
    public val components: List<DevToolPortalComponentResponse>,
    public val features: DevToolPortalFeatureSettingsResponse? = null,
    public val provisioningState: String,
    public val `public`: Boolean? = null,
    public val ssoProperties: DevToolPortalSsoPropertiesResponse? = null,
    public val url: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.DevToolPortalPropertiesResponse):
            DevToolPortalPropertiesResponse = DevToolPortalPropertiesResponse(
            components = javaType.components().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.DevToolPortalComponentResponse.Companion.toKotlin(args0)
                })
            }),
            features = javaType.features().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.DevToolPortalFeatureSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            `public` = javaType.public_().map({ args0 -> args0 }).orElse(null),
            ssoProperties = javaType.ssoProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.DevToolPortalSsoPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            url = javaType.url(),
        )
    }
}
