@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The resource quantity for required CPU and Memory of Dev Tool Portal
 * @property cpu Cpu quantity allocated to each Dev Tool Portal instance. 1 core can be represented by 1 or 1000m
 * @property instanceCount Desired instance count of Dev Tool Portal.
 * @property memory Memory quantity allocated to each Dev Tool Portal instance. 1 GB can be represented by 1Gi or 1024Mi.
 */
public data class DevToolPortalResourceRequestsResponse(
    public val cpu: String,
    public val instanceCount: Int,
    public val memory: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.DevToolPortalResourceRequestsResponse):
            DevToolPortalResourceRequestsResponse = DevToolPortalResourceRequestsResponse(
            cpu = javaType.cpu(),
            instanceCount = javaType.instanceCount(),
            memory = javaType.memory(),
        )
    }
}
