@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * OpenAPI properties of Spring Cloud Gateway route config.
 * @property uri The URI of OpenAPI specification.
 */
public data class GatewayRouteConfigOpenApiPropertiesResponse(
    public val uri: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GatewayRouteConfigOpenApiPropertiesResponse):
            GatewayRouteConfigOpenApiPropertiesResponse = GatewayRouteConfigOpenApiPropertiesResponse(
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
