@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Build result log resource properties payload
 * @property blobUrl The public download URL of this build result log
 */
public data class GetBuildServiceBuildResultLogResult(
    public val blobUrl: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GetBuildServiceBuildResultLogResult):
            GetBuildServiceBuildResultLogResult = GetBuildServiceBuildResultLogResult(
            blobUrl = javaType.blobUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
