@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Customized accelerator resource
 * @property id Fully qualified resource Id for the resource.
 * @property name The name of the resource.
 * @property properties Customized accelerator properties payload
 * @property sku Sku of the customized accelerator resource
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource.
 */
public data class GetCustomizedAcceleratorResult(
    public val id: String,
    public val name: String,
    public val properties: CustomizedAcceleratorPropertiesResponse,
    public val sku: SkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.GetCustomizedAcceleratorResult):
            GetCustomizedAcceleratorResult = GetCustomizedAcceleratorResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.CustomizedAcceleratorPropertiesResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.appplatform.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.appplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
