@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of certificate imported from key vault.
 * @property activateDate The activate date of certificate.
 * @property certVersion The certificate version of key vault.
 * @property dnsNames The domain list of certificate.
 * @property excludePrivateKey Optional. If set to true, it will not import private key from key vault.
 * @property expirationDate The expiration date of certificate.
 * @property issuedDate The issue date of certificate.
 * @property issuer The issuer of certificate.
 * @property keyVaultCertName The certificate name of key vault.
 * @property provisioningState Provisioning state of the Certificate
 * @property subjectName The subject name of certificate.
 * @property thumbprint The thumbprint of certificate.
 * @property type The type of the certificate source.
 * Expected value is 'KeyVaultCertificate'.
 * @property vaultUri The vault uri of user key vault.
 */
public data class KeyVaultCertificatePropertiesResponse(
    public val activateDate: String,
    public val certVersion: String? = null,
    public val dnsNames: List<String>,
    public val excludePrivateKey: Boolean? = null,
    public val expirationDate: String,
    public val issuedDate: String,
    public val issuer: String,
    public val keyVaultCertName: String,
    public val provisioningState: String,
    public val subjectName: String,
    public val thumbprint: String,
    public val type: String,
    public val vaultUri: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.KeyVaultCertificatePropertiesResponse):
            KeyVaultCertificatePropertiesResponse = KeyVaultCertificatePropertiesResponse(
            activateDate = javaType.activateDate(),
            certVersion = javaType.certVersion().map({ args0 -> args0 }).orElse(null),
            dnsNames = javaType.dnsNames().map({ args0 -> args0 }),
            excludePrivateKey = javaType.excludePrivateKey().map({ args0 -> args0 }).orElse(null),
            expirationDate = javaType.expirationDate(),
            issuedDate = javaType.issuedDate(),
            issuer = javaType.issuer(),
            keyVaultCertName = javaType.keyVaultCertName(),
            provisioningState = javaType.provisioningState(),
            subjectName = javaType.subjectName(),
            thumbprint = javaType.thumbprint(),
            type = javaType.type(),
            vaultUri = javaType.vaultUri(),
        )
    }
}
