@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Managed identity properties retrieved from ARM request headers.
 * @property principalId Principal Id of system-assigned managed identity.
 * @property tenantId Tenant Id of system-assigned managed identity.
 * @property type Type of the managed identity
 * @property userAssignedIdentities Properties of user-assigned managed identities
 */
public data class ManagedIdentityPropertiesResponse(
    public val principalId: String? = null,
    public val tenantId: String? = null,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, UserAssignedManagedIdentityResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ManagedIdentityPropertiesResponse):
            ManagedIdentityPropertiesResponse = ManagedIdentityPropertiesResponse(
            principalId = javaType.principalId().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.appplatform.kotlin.outputs.UserAssignedManagedIdentityResponse.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
