@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Probe describes a health check to be performed against an App Instance to determine whether it is alive or ready to receive traffic.
 * @property disableProbe Indicate whether the probe is disabled.
 * @property failureThreshold Minimum consecutive failures for the probe to be considered failed after having succeeded. Minimum value is 1.
 * @property initialDelaySeconds Number of seconds after the App Instance has started before probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
 * @property periodSeconds How often (in seconds) to perform the probe. Minimum value is 1.
 * @property probeAction The action of the probe.
 * @property successThreshold Minimum consecutive successes for the probe to be considered successful after having failed. Must be 1 for liveness and startup. Minimum value is 1.
 * @property timeoutSeconds Number of seconds after which the probe times out. Minimum value is 1.
 */
public data class ProbeResponse(
    public val disableProbe: Boolean,
    public val failureThreshold: Int? = null,
    public val initialDelaySeconds: Int? = null,
    public val periodSeconds: Int? = null,
    public val probeAction: Any? = null,
    public val successThreshold: Int? = null,
    public val timeoutSeconds: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.ProbeResponse):
            ProbeResponse = ProbeResponse(
            disableProbe = javaType.disableProbe(),
            failureThreshold = javaType.failureThreshold().map({ args0 -> args0 }).orElse(null),
            initialDelaySeconds = javaType.initialDelaySeconds().map({ args0 -> args0 }).orElse(null),
            periodSeconds = javaType.periodSeconds().map({ args0 -> args0 }).orElse(null),
            probeAction = javaType.probeAction().map({ args0 -> args0 }).orElse(null),
            successThreshold = javaType.successThreshold().map({ args0 -> args0 }).orElse(null),
            timeoutSeconds = javaType.timeoutSeconds().map({ args0 -> args0 }).orElse(null),
        )
    }
}
