@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.appplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * KPack ClusterStack properties payload
 * @property id Id of the ClusterStack.
 * @property version Version of the ClusterStack
 */
public data class StackPropertiesResponse(
    public val id: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.appplatform.outputs.StackPropertiesResponse):
            StackPropertiesResponse = StackPropertiesResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
