@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin

import com.pulumi.azurenative.attestation.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.attestation.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.attestation.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The Private Endpoint Connection resource.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2021-06-01-preview.
 * ## Example Usage
 * ### AttestationProviderPutPrivateEndpointConnection
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.Attestation.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         PrivateEndpointConnectionName = "{privateEndpointConnectionName}",
 *         PrivateLinkServiceConnectionState = new AzureNative.Attestation.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "Auto-Approved",
 *             Status = AzureNative.Attestation.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ProviderName = "sto9699",
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/attestation/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := attestation.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &attestation.PrivateEndpointConnectionArgs{
 * 			PrivateEndpointConnectionName: pulumi.String("{privateEndpointConnectionName}"),
 * 			PrivateLinkServiceConnectionState: &attestation.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("Auto-Approved"),
 * 				Status:      pulumi.String(attestation.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ProviderName:      pulumi.String("sto9699"),
 * 			ResourceGroupName: pulumi.String("res7687"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.attestation.PrivateEndpointConnection;
 * import com.pulumi.azurenative.attestation.PrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.attestation.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .privateEndpointConnectionName("{privateEndpointConnectionName}")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("Auto-Approved")
 *                 .status("Approved")
 *                 .build())
 *             .providerName("sto9699")
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:attestation:PrivateEndpointConnection {privateEndpointConnectionName} /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Attestation/attestationProviders/{providerName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property providerName The name of the attestation provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class PrivateEndpointConnectionArgs(
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val providerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.attestation.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.attestation.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.attestation.PrivateEndpointConnectionArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .providerName(providerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var providerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("wdmvxacsglaxcccs")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("gfrjqqkxnmdoiteq")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the attestation provider.
     */
    @JvmName("dsemirxljejaeokl")
    public suspend fun providerName(`value`: Output<String>) {
        this.providerName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("coixaobycldsvmyf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("xbncnyyjbrumalad")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("wxmtgpvxkndlbxob")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("dmhsbppwrjxdjexf")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the attestation provider.
     */
    @JvmName("iscygncdmtdrqslp")
    public suspend fun providerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sojsylovqwphbrhj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        providerName = providerName,
        resourceGroupName = resourceGroupName,
    )
}
