@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.attestation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Attestation service response message.
 * @property attestUri Gets the uri of attestation service
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property privateEndpointConnections List of private endpoint connections associated with the attestation provider.
 * @property publicNetworkAccess Controls whether traffic from the public network is allowed to access the Attestation Provider APIs.
 * @property status Status of attestation service.
 * @property systemData The system metadata relating to this resource
 * @property tags Resource tags.
 * @property tpmAttestationAuthentication The setting that controls whether authentication is enabled or disabled for TPM Attestation REST APIs.
 * @property trustModel Trust model for the attestation provider.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetAttestationProviderResult(
    public val attestUri: String? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val publicNetworkAccess: String? = null,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tpmAttestationAuthentication: String? = null,
    public val trustModel: String? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.attestation.outputs.GetAttestationProviderResult):
            GetAttestationProviderResult = GetAttestationProviderResult(
            attestUri = javaType.attestUri().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.attestation.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.attestation.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tpmAttestationAuthentication = javaType.tpmAttestationAuthentication().map({ args0 ->
                args0
            }).orElse(null),
            trustModel = javaType.trustModel().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
