@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewInstanceResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewReviewerResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewInstanceResponse.Companion.toKotlin as accessReviewInstanceResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.AccessReviewReviewerResponse.Companion.toKotlin as accessReviewReviewerResponseToKotlin

/**
 * Builder for [AccessReviewScheduleDefinitionById].
 */
@PulumiTagMarker
public class AccessReviewScheduleDefinitionByIdResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessReviewScheduleDefinitionByIdArgs = AccessReviewScheduleDefinitionByIdArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessReviewScheduleDefinitionByIdArgsBuilder.() -> Unit) {
        val builder = AccessReviewScheduleDefinitionByIdArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessReviewScheduleDefinitionById {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.AccessReviewScheduleDefinitionById(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AccessReviewScheduleDefinitionById(builtJavaResource)
    }
}

/**
 * Access Review Schedule Definition.
 * Azure REST API version: 2021-12-01-preview. Prior API version in Azure Native 1.x: 2021-03-01-preview.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:AccessReviewScheduleDefinitionById myresource1 /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/accessReviewScheduleDefinitions/{scheduleDefinitionId}
 * ```
 */
public class AccessReviewScheduleDefinitionById internal constructor(
    override val javaResource:
    com.pulumi.azurenative.authorization.AccessReviewScheduleDefinitionById,
) : KotlinCustomResource(javaResource, AccessReviewScheduleDefinitionByIdMapper) {
    /**
     * The role assignment state eligible/active to review
     */
    public val assignmentState: Output<String>
        get() = javaResource.assignmentState().applyValue({ args0 -> args0 })

    /**
     * Flag to indicate whether auto-apply capability, to automatically change the target object access resource, is enabled. If not enabled, a user must, after the review completes, apply the access review.
     */
    public val autoApplyDecisionsEnabled: Output<Boolean>?
        get() = javaResource.autoApplyDecisionsEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is the collection of backup reviewers.
     */
    public val backupReviewers: Output<List<AccessReviewReviewerResponse>>?
        get() = javaResource.backupReviewers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        accessReviewReviewerResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * This specifies the behavior for the autoReview feature when an access review completes.
     */
    public val defaultDecision: Output<String>?
        get() = javaResource.defaultDecision().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to indicate whether reviewers are required to provide a justification when reviewing access.
     */
    public val defaultDecisionEnabled: Output<Boolean>?
        get() = javaResource.defaultDecisionEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description provided by the access review creator and visible to admins.
     */
    public val descriptionForAdmins: Output<String>?
        get() = javaResource.descriptionForAdmins().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description provided by the access review creator to be shown to reviewers.
     */
    public val descriptionForReviewers: Output<String>?
        get() = javaResource.descriptionForReviewers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name for the schedule definition.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The DateTime when the review is scheduled to end. Required if type is endDate
     */
    public val endDate: Output<String>?
        get() = javaResource.endDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This is used to indicate the resource id(s) to exclude
     */
    public val excludeResourceId: Output<String>?
        get() = javaResource.excludeResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is used to indicate the role definition id(s) to exclude
     */
    public val excludeRoleDefinitionId: Output<String>?
        get() = javaResource.excludeRoleDefinitionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to indicate whether to expand nested memberships or not.
     */
    public val expandNestedMemberships: Output<Boolean>?
        get() = javaResource.expandNestedMemberships().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
     */
    public val inactiveDuration: Output<String>?
        get() = javaResource.inactiveDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to indicate whether to expand nested memberships or not.
     */
    public val includeAccessBelowResource: Output<Boolean>?
        get() = javaResource.includeAccessBelowResource().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to indicate whether to expand nested memberships or not.
     */
    public val includeInheritedAccess: Output<Boolean>?
        get() = javaResource.includeInheritedAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The duration in days for an instance.
     */
    public val instanceDurationInDays: Output<Int>?
        get() = javaResource.instanceDurationInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * This is the collection of instances returned when one does an expand on it.
     */
    public val instances: Output<List<AccessReviewInstanceResponse>>?
        get() = javaResource.instances().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> accessReviewInstanceResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The interval for recurrence. For a quarterly review, the interval is 3 for type : absoluteMonthly.
     */
    public val interval: Output<Int>?
        get() = javaResource.interval().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Flag to indicate whether the reviewer is required to pass justification when recording a decision.
     */
    public val justificationRequiredOnApproval: Output<Boolean>?
        get() = javaResource.justificationRequiredOnApproval().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to indicate whether sending mails to reviewers and the review creator is enabled.
     */
    public val mailNotificationsEnabled: Output<Boolean>?
        get() = javaResource.mailNotificationsEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The access review schedule definition unique id.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The number of times to repeat the access review. Required and must be positive if type is numbered.
     */
    public val numberOfOccurrences: Output<Int>?
        get() = javaResource.numberOfOccurrences().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The identity id
     */
    public val principalId: Output<String>
        get() = javaResource.principalId().applyValue({ args0 -> args0 })

    /**
     * The identity display name
     */
    public val principalName: Output<String>
        get() = javaResource.principalName().applyValue({ args0 -> args0 })

    /**
     * The identity type user/servicePrincipal to review
     */
    public val principalType: Output<String>
        get() = javaResource.principalType().applyValue({ args0 -> args0 })

    /**
     * Recommendations for access reviews are calculated by looking back at 30 days of data(w.r.t the start date of the review) by default. However, in some scenarios, customers want to change how far back to look at and want to configure 60 days, 90 days, etc. instead. This setting allows customers to configure this duration. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
     */
    public val recommendationLookBackDuration: Output<String>?
        get() = javaResource.recommendationLookBackDuration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to indicate whether showing recommendations to reviewers is enabled.
     */
    public val recommendationsEnabled: Output<Boolean>?
        get() = javaResource.recommendationsEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Flag to indicate whether sending reminder emails to reviewers are enabled.
     */
    public val reminderNotificationsEnabled: Output<Boolean>?
        get() = javaResource.reminderNotificationsEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ResourceId in which this review is getting created
     */
    public val resourceId: Output<String>
        get() = javaResource.resourceId().applyValue({ args0 -> args0 })

    /**
     * This is the collection of reviewers.
     */
    public val reviewers: Output<List<AccessReviewReviewerResponse>>?
        get() = javaResource.reviewers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> accessReviewReviewerResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * This field specifies the type of reviewers for a review. Usually for a review, reviewers are explicitly assigned. However, in some cases, the reviewers may not be assigned and instead be chosen dynamically. For example managers review or self review.
     */
    public val reviewersType: Output<String>
        get() = javaResource.reviewersType().applyValue({ args0 -> args0 })

    /**
     * This is used to indicate the role being reviewed
     */
    public val roleDefinitionId: Output<String>
        get() = javaResource.roleDefinitionId().applyValue({ args0 -> args0 })

    /**
     * The DateTime when the review is scheduled to be start. This could be a date in the future. Required on create.
     */
    public val startDate: Output<String>?
        get() = javaResource.startDate().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * This read-only field specifies the status of an accessReview.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The user principal name(if valid)
     */
    public val userPrincipalName: Output<String>
        get() = javaResource.userPrincipalName().applyValue({ args0 -> args0 })
}

public object AccessReviewScheduleDefinitionByIdMapper :
    ResourceMapper<AccessReviewScheduleDefinitionById> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.AccessReviewScheduleDefinitionById::class == javaResource::class

    override fun map(javaResource: Resource): AccessReviewScheduleDefinitionById =
        AccessReviewScheduleDefinitionById(
            javaResource as
                com.pulumi.azurenative.authorization.AccessReviewScheduleDefinitionById,
        )
}

/**
 * @see [AccessReviewScheduleDefinitionById].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessReviewScheduleDefinitionById].
 */
public suspend fun accessReviewScheduleDefinitionById(
    name: String,
    block: suspend AccessReviewScheduleDefinitionByIdResourceBuilder.() -> Unit,
):
    AccessReviewScheduleDefinitionById {
    val builder = AccessReviewScheduleDefinitionByIdResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessReviewScheduleDefinitionById].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessReviewScheduleDefinitionById(name: String): AccessReviewScheduleDefinitionById {
    val builder = AccessReviewScheduleDefinitionByIdResourceBuilder()
    builder.name(name)
    return builder.build()
}
