@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.ManagementLockAtResourceLevelArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.LockLevel
import com.pulumi.azurenative.authorization.kotlin.inputs.ManagementLockOwnerArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ManagementLockOwnerArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The lock information.
 * Azure REST API version: 2020-05-01. Prior API version in Azure Native 1.x: 2017-04-01.
 * ## Example Usage
 * ### Create management lock at resource level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managementLockAtResourceLevel = new AzureNative.Authorization.ManagementLockAtResourceLevel("managementLockAtResourceLevel", new()
 *     {
 *         Level = AzureNative.Authorization.LockLevel.ReadOnly,
 *         LockName = "testlock",
 *         ParentResourcePath = "parentResourcePath",
 *         ResourceGroupName = "resourcegroupname",
 *         ResourceName = "teststorageaccount",
 *         ResourceProviderNamespace = "Microsoft.Storage",
 *         ResourceType = "storageAccounts",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewManagementLockAtResourceLevel(ctx, "managementLockAtResourceLevel", &authorization.ManagementLockAtResourceLevelArgs{
 * 			Level:                     pulumi.String(authorization.LockLevelReadOnly),
 * 			LockName:                  pulumi.String("testlock"),
 * 			ParentResourcePath:        pulumi.String("parentResourcePath"),
 * 			ResourceGroupName:         pulumi.String("resourcegroupname"),
 * 			ResourceName:              pulumi.String("teststorageaccount"),
 * 			ResourceProviderNamespace: pulumi.String("Microsoft.Storage"),
 * 			ResourceType:              pulumi.String("storageAccounts"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.ManagementLockAtResourceLevel;
 * import com.pulumi.azurenative.authorization.ManagementLockAtResourceLevelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managementLockAtResourceLevel = new ManagementLockAtResourceLevel("managementLockAtResourceLevel", ManagementLockAtResourceLevelArgs.builder()
 *             .level("ReadOnly")
 *             .lockName("testlock")
 *             .parentResourcePath("parentResourcePath")
 *             .resourceGroupName("resourcegroupname")
 *             .resourceName("teststorageaccount")
 *             .resourceProviderNamespace("Microsoft.Storage")
 *             .resourceType("storageAccounts")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:ManagementLockAtResourceLevel testlock /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{parentResourcePath}/{resourceType}/{resourceName}/providers/Microsoft.Authorization/locks/{lockName}
 * ```
 * @property level The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
 * @property lockName The name of lock. The lock name can be a maximum of 260 characters. It cannot contain <, > %, &, :, \, ?, /, or any control characters.
 * @property notes Notes about the lock. Maximum of 512 characters.
 * @property owners The owners of the lock.
 * @property parentResourcePath The parent resource identity.
 * @property resourceGroupName The name of the resource group containing the resource to lock.
 * @property resourceName The name of the resource to lock.
 * @property resourceProviderNamespace The resource provider namespace of the resource to lock.
 * @property resourceType The resource type of the resource to lock.
 */
public data class ManagementLockAtResourceLevelArgs(
    public val level: Output<Either<String, LockLevel>>? = null,
    public val lockName: Output<String>? = null,
    public val notes: Output<String>? = null,
    public val owners: Output<List<ManagementLockOwnerArgs>>? = null,
    public val parentResourcePath: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val resourceProviderNamespace: Output<String>? = null,
    public val resourceType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.ManagementLockAtResourceLevelArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.ManagementLockAtResourceLevelArgs =
        com.pulumi.azurenative.authorization.ManagementLockAtResourceLevelArgs.builder()
            .level(
                level?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .lockName(lockName?.applyValue({ args0 -> args0 }))
            .notes(notes?.applyValue({ args0 -> args0 }))
            .owners(owners?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .parentResourcePath(parentResourcePath?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .resourceProviderNamespace(resourceProviderNamespace?.applyValue({ args0 -> args0 }))
            .resourceType(resourceType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagementLockAtResourceLevelArgs].
 */
@PulumiTagMarker
public class ManagementLockAtResourceLevelArgsBuilder internal constructor() {
    private var level: Output<Either<String, LockLevel>>? = null

    private var lockName: Output<String>? = null

    private var notes: Output<String>? = null

    private var owners: Output<List<ManagementLockOwnerArgs>>? = null

    private var parentResourcePath: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var resourceProviderNamespace: Output<String>? = null

    private var resourceType: Output<String>? = null

    /**
     * @param value The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
     */
    @JvmName("ruvlmpfewkvmyyty")
    public suspend fun level(`value`: Output<Either<String, LockLevel>>) {
        this.level = value
    }

    /**
     * @param value The name of lock. The lock name can be a maximum of 260 characters. It cannot contain <, > %, &, :, \, ?, /, or any control characters.
     */
    @JvmName("mhnbsabsygchekaa")
    public suspend fun lockName(`value`: Output<String>) {
        this.lockName = value
    }

    /**
     * @param value Notes about the lock. Maximum of 512 characters.
     */
    @JvmName("bitfxnpuyaantpuu")
    public suspend fun notes(`value`: Output<String>) {
        this.notes = value
    }

    /**
     * @param value The owners of the lock.
     */
    @JvmName("ewgmxrupnlnwdbvx")
    public suspend fun owners(`value`: Output<List<ManagementLockOwnerArgs>>) {
        this.owners = value
    }

    @JvmName("gwiltkaiqujoqlai")
    public suspend fun owners(vararg values: Output<ManagementLockOwnerArgs>) {
        this.owners = Output.all(values.asList())
    }

    /**
     * @param values The owners of the lock.
     */
    @JvmName("qvwgyvuskmgqoctq")
    public suspend fun owners(values: List<Output<ManagementLockOwnerArgs>>) {
        this.owners = Output.all(values)
    }

    /**
     * @param value The parent resource identity.
     */
    @JvmName("jjmdgqiidvrhdfyr")
    public suspend fun parentResourcePath(`value`: Output<String>) {
        this.parentResourcePath = value
    }

    /**
     * @param value The name of the resource group containing the resource to lock.
     */
    @JvmName("fmfrexwvcvsgbnux")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource to lock.
     */
    @JvmName("xtsphppyexqekoph")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The resource provider namespace of the resource to lock.
     */
    @JvmName("aacmwypduxdhyokv")
    public suspend fun resourceProviderNamespace(`value`: Output<String>) {
        this.resourceProviderNamespace = value
    }

    /**
     * @param value The resource type of the resource to lock.
     */
    @JvmName("wcamxircofhwmxwf")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
     */
    @JvmName("iipijlgaalbltiik")
    public suspend fun level(`value`: Either<String, LockLevel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
     */
    @JvmName("kyowkbrxyvhjtkxw")
    public fun level(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LockLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
     */
    @JvmName("ngqodnveqpldyxdx")
    public fun level(`value`: LockLevel) {
        val toBeMapped = Either.ofRight<String, LockLevel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value The name of lock. The lock name can be a maximum of 260 characters. It cannot contain <, > %, &, :, \, ?, /, or any control characters.
     */
    @JvmName("pelvuishxodagonm")
    public suspend fun lockName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lockName = mapped
    }

    /**
     * @param value Notes about the lock. Maximum of 512 characters.
     */
    @JvmName("obguvjnqhbucaqju")
    public suspend fun notes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notes = mapped
    }

    /**
     * @param value The owners of the lock.
     */
    @JvmName("hgorggkxrdwctnpd")
    public suspend fun owners(`value`: List<ManagementLockOwnerArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.owners = mapped
    }

    /**
     * @param argument The owners of the lock.
     */
    @JvmName("tiwvkulrpwckmhbp")
    public suspend fun owners(argument: List<suspend ManagementLockOwnerArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagementLockOwnerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.owners = mapped
    }

    /**
     * @param argument The owners of the lock.
     */
    @JvmName("prbjnwiclaquwftv")
    public suspend fun owners(vararg argument: suspend ManagementLockOwnerArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagementLockOwnerArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.owners = mapped
    }

    /**
     * @param argument The owners of the lock.
     */
    @JvmName("chmdsfpojyuexrks")
    public suspend fun owners(argument: suspend ManagementLockOwnerArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManagementLockOwnerArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.owners = mapped
    }

    /**
     * @param values The owners of the lock.
     */
    @JvmName("gcgudtormjbvulgy")
    public suspend fun owners(vararg values: ManagementLockOwnerArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.owners = mapped
    }

    /**
     * @param value The parent resource identity.
     */
    @JvmName("afevasmmfdrypusj")
    public suspend fun parentResourcePath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentResourcePath = mapped
    }

    /**
     * @param value The name of the resource group containing the resource to lock.
     */
    @JvmName("lbhaehwiokbuanff")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource to lock.
     */
    @JvmName("qsrdscpwvbvmcwsh")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The resource provider namespace of the resource to lock.
     */
    @JvmName("nvtjigbsoyjdukua")
    public suspend fun resourceProviderNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceProviderNamespace = mapped
    }

    /**
     * @param value The resource type of the resource to lock.
     */
    @JvmName("oejltmqdhhplejuk")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    internal fun build(): ManagementLockAtResourceLevelArgs = ManagementLockAtResourceLevelArgs(
        level = level,
        lockName = lockName,
        notes = notes,
        owners = owners,
        parentResourcePath = parentResourcePath,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        resourceProviderNamespace = resourceProviderNamespace,
        resourceType = resourceType,
    )
}
