@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.NonComplianceMessageResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.OverrideResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterValuesValueResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.ResourceSelectorResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.authorization.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.NonComplianceMessageResponse.Companion.toKotlin as nonComplianceMessageResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.OverrideResponse.Companion.toKotlin as overrideResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterValuesValueResponse.Companion.toKotlin as parameterValuesValueResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.ResourceSelectorResponse.Companion.toKotlin as resourceSelectorResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PolicyAssignment].
 */
@PulumiTagMarker
public class PolicyAssignmentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyAssignmentArgs = PolicyAssignmentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyAssignmentArgsBuilder.() -> Unit) {
        val builder = PolicyAssignmentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicyAssignment {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.PolicyAssignment(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicyAssignment(builtJavaResource)
    }
}

/**
 * The policy assignment.
 * Azure REST API version: 2022-06-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2016-04-01, 2016-12-01, 2019-06-01, 2020-03-01, 2023-04-01, 2024-04-01.
 * ## Example Usage
 * ### Create or update a policy assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         Description = "Force resource names to begin with given DeptA and end with -LC",
 *         DisplayName = "Enforce resource naming rules",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["assignedBy"] = "Special Someone",
 *         },
 *         NonComplianceMessages = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.NonComplianceMessageArgs
 *             {
 *                 Message = "Resource names must start with 'DeptA' and end with '-LC'.",
 *             },
 *         },
 *         Parameters =
 *         {
 *             { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "DeptA",
 *             } },
 *             { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "-LC",
 *             } },
 *         },
 *         PolicyAssignmentName = "EnforceNaming",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			Description: pulumi.String("Force resource names to begin with given DeptA and end with -LC"),
 * 			DisplayName: pulumi.String("Enforce resource naming rules"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"assignedBy": "Special Someone",
 * 			}),
 * 			NonComplianceMessages: authorization.NonComplianceMessageArray{
 * 				&authorization.NonComplianceMessageArgs{
 * 					Message: pulumi.String("Resource names must start with 'DeptA' and end with '-LC'."),
 * 				},
 * 			},
 * 			Parameters: authorization.ParameterValuesValueMap{
 * 				"prefix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("DeptA"),
 * 				},
 * 				"suffix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("-LC"),
 * 				},
 * 			},
 * 			PolicyAssignmentName: pulumi.String("EnforceNaming"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 			Scope:                pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import com.pulumi.azurenative.authorization.inputs.NonComplianceMessageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .description("Force resource names to begin with given DeptA and end with -LC")
 *             .displayName("Enforce resource naming rules")
 *             .metadata(Map.of("assignedBy", "Special Someone"))
 *             .nonComplianceMessages(NonComplianceMessageArgs.builder()
 *                 .message("Resource names must start with 'DeptA' and end with '-LC'.")
 *                 .build())
 *             .parameters(Map.ofEntries(
 *                 Map.entry("prefix", Map.of("value", "DeptA")),
 *                 Map.entry("suffix", Map.of("value", "-LC"))
 *             ))
 *             .policyAssignmentName("EnforceNaming")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy assignment with a system assigned identity
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         Description = "Force resource names to begin with given DeptA and end with -LC",
 *         DisplayName = "Enforce resource naming rules",
 *         EnforcementMode = AzureNative.Authorization.EnforcementMode.Default,
 *         Identity = new AzureNative.Authorization.Inputs.IdentityArgs
 *         {
 *             Type = AzureNative.Authorization.ResourceIdentityType.SystemAssigned,
 *         },
 *         Location = "eastus",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["assignedBy"] = "Foo Bar",
 *         },
 *         Parameters =
 *         {
 *             { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "DeptA",
 *             } },
 *             { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "-LC",
 *             } },
 *         },
 *         PolicyAssignmentName = "EnforceNaming",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			Description:     pulumi.String("Force resource names to begin with given DeptA and end with -LC"),
 * 			DisplayName:     pulumi.String("Enforce resource naming rules"),
 * 			EnforcementMode: pulumi.String(authorization.EnforcementModeDefault),
 * 			Identity: &authorization.IdentityArgs{
 * 				Type: authorization.ResourceIdentityTypeSystemAssigned,
 * 			},
 * 			Location: pulumi.String("eastus"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"assignedBy": "Foo Bar",
 * 			}),
 * 			Parameters: authorization.ParameterValuesValueMap{
 * 				"prefix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("DeptA"),
 * 				},
 * 				"suffix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("-LC"),
 * 				},
 * 			},
 * 			PolicyAssignmentName: pulumi.String("EnforceNaming"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 			Scope:                pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import com.pulumi.azurenative.authorization.inputs.IdentityArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .description("Force resource names to begin with given DeptA and end with -LC")
 *             .displayName("Enforce resource naming rules")
 *             .enforcementMode("Default")
 *             .identity(IdentityArgs.builder()
 *                 .type("SystemAssigned")
 *                 .build())
 *             .location("eastus")
 *             .metadata(Map.of("assignedBy", "Foo Bar"))
 *             .parameters(Map.ofEntries(
 *                 Map.entry("prefix", Map.of("value", "DeptA")),
 *                 Map.entry("suffix", Map.of("value", "-LC"))
 *             ))
 *             .policyAssignmentName("EnforceNaming")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy assignment with multiple non-compliance messages
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         DisplayName = "Enforce security policies",
 *         NonComplianceMessages = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.NonComplianceMessageArgs
 *             {
 *                 Message = "Resources must comply with all internal security policies. See <internal site URL> for more info.",
 *             },
 *             new AzureNative.Authorization.Inputs.NonComplianceMessageArgs
 *             {
 *                 Message = "Resource names must start with 'DeptA' and end with '-LC'.",
 *                 PolicyDefinitionReferenceId = "10420126870854049575",
 *             },
 *             new AzureNative.Authorization.Inputs.NonComplianceMessageArgs
 *             {
 *                 Message = "Storage accounts must have firewall rules configured.",
 *                 PolicyDefinitionReferenceId = "8572513655450389710",
 *             },
 *         },
 *         PolicyAssignmentName = "securityInitAssignment",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/securityInitiative",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			DisplayName: pulumi.String("Enforce security policies"),
 * 			NonComplianceMessages: authorization.NonComplianceMessageArray{
 * 				&authorization.NonComplianceMessageArgs{
 * 					Message: pulumi.String("Resources must comply with all internal security policies. See <internal site URL> for more info."),
 * 				},
 * 				&authorization.NonComplianceMessageArgs{
 * 					Message:                     pulumi.String("Resource names must start with 'DeptA' and end with '-LC'."),
 * 					PolicyDefinitionReferenceId: pulumi.String("10420126870854049575"),
 * 				},
 * 				&authorization.NonComplianceMessageArgs{
 * 					Message:                     pulumi.String("Storage accounts must have firewall rules configured."),
 * 					PolicyDefinitionReferenceId: pulumi.String("8572513655450389710"),
 * 				},
 * 			},
 * 			PolicyAssignmentName: pulumi.String("securityInitAssignment"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/securityInitiative"),
 * 			Scope:                pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import com.pulumi.azurenative.authorization.inputs.NonComplianceMessageArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .displayName("Enforce security policies")
 *             .nonComplianceMessages(
 *                 NonComplianceMessageArgs.builder()
 *                     .message("Resources must comply with all internal security policies. See <internal site URL> for more info.")
 *                     .build(),
 *                 NonComplianceMessageArgs.builder()
 *                     .message("Resource names must start with 'DeptA' and end with '-LC'.")
 *                     .policyDefinitionReferenceId("10420126870854049575")
 *                     .build(),
 *                 NonComplianceMessageArgs.builder()
 *                     .message("Storage accounts must have firewall rules configured.")
 *                     .policyDefinitionReferenceId("8572513655450389710")
 *                     .build())
 *             .policyAssignmentName("securityInitAssignment")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/securityInitiative")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy assignment with overrides
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         Description = "Limit the resource location and resource SKU",
 *         DisplayName = "Limit the resource location and resource SKU",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["assignedBy"] = "Special Someone",
 *         },
 *         Overrides = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.OverrideArgs
 *             {
 *                 Kind = AzureNative.Authorization.OverrideKind.PolicyEffect,
 *                 Selectors = new[]
 *                 {
 *                     new AzureNative.Authorization.Inputs.SelectorArgs
 *                     {
 *                         In = new[]
 *                         {
 *                             "Limit_Skus",
 *                             "Limit_Locations",
 *                         },
 *                         Kind = AzureNative.Authorization.SelectorKind.PolicyDefinitionReferenceId,
 *                     },
 *                 },
 *                 Value = "Audit",
 *             },
 *         },
 *         PolicyAssignmentName = "CostManagement",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			Description: pulumi.String("Limit the resource location and resource SKU"),
 * 			DisplayName: pulumi.String("Limit the resource location and resource SKU"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"assignedBy": "Special Someone",
 * 			}),
 * 			Overrides: authorization.OverrideArray{
 * 				&authorization.OverrideArgs{
 * 					Kind: pulumi.String(authorization.OverrideKindPolicyEffect),
 * 					Selectors: authorization.SelectorArray{
 * 						&authorization.SelectorArgs{
 * 							In: pulumi.StringArray{
 * 								pulumi.String("Limit_Skus"),
 * 								pulumi.String("Limit_Locations"),
 * 							},
 * 							Kind: pulumi.String(authorization.SelectorKindPolicyDefinitionReferenceId),
 * 						},
 * 					},
 * 					Value: pulumi.String("Audit"),
 * 				},
 * 			},
 * 			PolicyAssignmentName: pulumi.String("CostManagement"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
 * 			Scope:                pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import com.pulumi.azurenative.authorization.inputs.OverrideArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .description("Limit the resource location and resource SKU")
 *             .displayName("Limit the resource location and resource SKU")
 *             .metadata(Map.of("assignedBy", "Special Someone"))
 *             .overrides(OverrideArgs.builder()
 *                 .kind("policyEffect")
 *                 .selectors(SelectorArgs.builder()
 *                     .in(
 *                         "Limit_Skus",
 *                         "Limit_Locations")
 *                     .kind("policyDefinitionReferenceId")
 *                     .build())
 *                 .value("Audit")
 *                 .build())
 *             .policyAssignmentName("CostManagement")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy assignment with resource selectors
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         Description = "Limit the resource location and resource SKU",
 *         DisplayName = "Limit the resource location and resource SKU",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["assignedBy"] = "Special Someone",
 *         },
 *         PolicyAssignmentName = "CostManagement",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement",
 *         ResourceSelectors = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.ResourceSelectorArgs
 *             {
 *                 Name = "SDPRegions",
 *                 Selectors = new[]
 *                 {
 *                     new AzureNative.Authorization.Inputs.SelectorArgs
 *                     {
 *                         In = new[]
 *                         {
 *                             "eastus2euap",
 *                             "centraluseuap",
 *                         },
 *                         Kind = AzureNative.Authorization.SelectorKind.ResourceLocation,
 *                     },
 *                 },
 *             },
 *         },
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			Description: pulumi.String("Limit the resource location and resource SKU"),
 * 			DisplayName: pulumi.String("Limit the resource location and resource SKU"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"assignedBy": "Special Someone",
 * 			}),
 * 			PolicyAssignmentName: pulumi.String("CostManagement"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement"),
 * 			ResourceSelectors: authorization.ResourceSelectorArray{
 * 				&authorization.ResourceSelectorArgs{
 * 					Name: pulumi.String("SDPRegions"),
 * 					Selectors: authorization.SelectorArray{
 * 						&authorization.SelectorArgs{
 * 							In: pulumi.StringArray{
 * 								pulumi.String("eastus2euap"),
 * 								pulumi.String("centraluseuap"),
 * 							},
 * 							Kind: pulumi.String(authorization.SelectorKindResourceLocation),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Scope: pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import com.pulumi.azurenative.authorization.inputs.ResourceSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .description("Limit the resource location and resource SKU")
 *             .displayName("Limit the resource location and resource SKU")
 *             .metadata(Map.of("assignedBy", "Special Someone"))
 *             .policyAssignmentName("CostManagement")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policySetDefinitions/CostManagement")
 *             .resourceSelectors(ResourceSelectorArgs.builder()
 *                 .name("SDPRegions")
 *                 .selectors(SelectorArgs.builder()
 *                     .in(
 *                         "eastus2euap",
 *                         "centraluseuap")
 *                     .kind("resourceLocation")
 *                     .build())
 *                 .build())
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy assignment without enforcing policy effect during resource creation or update.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyAssignment = new AzureNative.Authorization.PolicyAssignment("policyAssignment", new()
 *     {
 *         Description = "Force resource names to begin with given DeptA and end with -LC",
 *         DisplayName = "Enforce resource naming rules",
 *         EnforcementMode = AzureNative.Authorization.EnforcementMode.DoNotEnforce,
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["assignedBy"] = "Special Someone",
 *         },
 *         Parameters =
 *         {
 *             { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "DeptA",
 *             } },
 *             { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *             {
 *                 Value = "-LC",
 *             } },
 *         },
 *         PolicyAssignmentName = "EnforceNaming",
 *         PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyAssignment(ctx, "policyAssignment", &authorization.PolicyAssignmentArgs{
 * 			Description:     pulumi.String("Force resource names to begin with given DeptA and end with -LC"),
 * 			DisplayName:     pulumi.String("Enforce resource naming rules"),
 * 			EnforcementMode: pulumi.String(authorization.EnforcementModeDoNotEnforce),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"assignedBy": "Special Someone",
 * 			}),
 * 			Parameters: authorization.ParameterValuesValueMap{
 * 				"prefix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("DeptA"),
 * 				},
 * 				"suffix": &authorization.ParameterValuesValueArgs{
 * 					Value: pulumi.Any("-LC"),
 * 				},
 * 			},
 * 			PolicyAssignmentName: pulumi.String("EnforceNaming"),
 * 			PolicyDefinitionId:   pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 			Scope:                pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyAssignment;
 * import com.pulumi.azurenative.authorization.PolicyAssignmentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyAssignment = new PolicyAssignment("policyAssignment", PolicyAssignmentArgs.builder()
 *             .description("Force resource names to begin with given DeptA and end with -LC")
 *             .displayName("Enforce resource naming rules")
 *             .enforcementMode("DoNotEnforce")
 *             .metadata(Map.of("assignedBy", "Special Someone"))
 *             .parameters(Map.ofEntries(
 *                 Map.entry("prefix", Map.of("value", "DeptA")),
 *                 Map.entry("suffix", Map.of("value", "-LC"))
 *             ))
 *             .policyAssignmentName("EnforceNaming")
 *             .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicyAssignment EnforceNaming /{scope}/providers/Microsoft.Authorization/policyAssignments/{policyAssignmentName}
 * ```
 */
public class PolicyAssignment internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.PolicyAssignment,
) : KotlinCustomResource(javaResource, PolicyAssignmentMapper) {
    /**
     * This message will be part of response in case of policy violation.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the policy assignment.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy assignment enforcement mode. Possible values are Default and DoNotEnforce.
     */
    public val enforcementMode: Output<String>?
        get() = javaResource.enforcementMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The managed identity associated with the policy assignment.
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The location of the policy assignment. Only required when utilizing managed identity.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The policy assignment metadata. Metadata is an open ended object and is typically a collection of key value pairs.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the policy assignment.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The messages that describe why a resource is non-compliant with the policy.
     */
    public val nonComplianceMessages: Output<List<NonComplianceMessageResponse>>?
        get() = javaResource.nonComplianceMessages().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        nonComplianceMessageResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The policy's excluded scopes.
     */
    public val notScopes: Output<List<String>>?
        get() = javaResource.notScopes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The policy property value override.
     */
    public val overrides: Output<List<OverrideResponse>>?
        get() = javaResource.overrides().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> overrideResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The parameter values for the assigned policy rule. The keys are the parameter names.
     */
    public val parameters: Output<Map<String, ParameterValuesValueResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            parameterValuesValueResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The ID of the policy definition or policy set definition being assigned.
     */
    public val policyDefinitionId: Output<String>?
        get() = javaResource.policyDefinitionId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The resource selector list to filter policies by resource properties.
     */
    public val resourceSelectors: Output<List<ResourceSelectorResponse>>?
        get() = javaResource.resourceSelectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        resourceSelectorResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The scope for the policy assignment.
     */
    public val scope: Output<String>
        get() = javaResource.scope().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the policy assignment.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicyAssignmentMapper : ResourceMapper<PolicyAssignment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.PolicyAssignment::class == javaResource::class

    override fun map(javaResource: Resource): PolicyAssignment = PolicyAssignment(
        javaResource as
            com.pulumi.azurenative.authorization.PolicyAssignment,
    )
}

/**
 * @see [PolicyAssignment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyAssignment].
 */
public suspend fun policyAssignment(
    name: String,
    block: suspend PolicyAssignmentResourceBuilder.() -> Unit,
): PolicyAssignment {
    val builder = PolicyAssignmentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyAssignment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyAssignment(name: String): PolicyAssignment {
    val builder = PolicyAssignmentResourceBuilder()
    builder.name(name)
    return builder.build()
}
