@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse.Companion.toKotlin as parameterDefinitionsValueResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PolicyDefinition].
 */
@PulumiTagMarker
public class PolicyDefinitionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyDefinitionArgs = PolicyDefinitionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyDefinitionArgsBuilder.() -> Unit) {
        val builder = PolicyDefinitionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicyDefinition {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.PolicyDefinition(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicyDefinition(builtJavaResource)
    }
}

/**
 * The policy definition.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2016-04-01, 2018-05-01, 2019-06-01, 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyDefinition = new AzureNative.Authorization.PolicyDefinition("policyDefinition", new()
 *     {
 *         Description = "Force resource names to begin with given 'prefix' and/or end with given 'suffix'",
 *         DisplayName = "Enforce resource naming convention",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["category"] = "Naming",
 *         },
 *         Mode = "All",
 *         Parameters =
 *         {
 *             { "prefix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "Resource name prefix",
 *                     DisplayName = "Prefix",
 *                 },
 *                 Type = AzureNative.Authorization.ParameterType.String,
 *             } },
 *             { "suffix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "Resource name suffix",
 *                     DisplayName = "Suffix",
 *                 },
 *                 Type = AzureNative.Authorization.ParameterType.String,
 *             } },
 *         },
 *         PolicyDefinitionName = "ResourceNaming",
 *         PolicyRule = new Dictionary<string, object?>
 *         {
 *             ["if"] = new Dictionary<string, object?>
 *             {
 *                 ["not"] = new Dictionary<string, object?>
 *                 {
 *                     ["field"] = "name",
 *                     ["like"] = "[concat(parameters('prefix'), '*', parameters('suffix'))]",
 *                 },
 *             },
 *             ["then"] = new Dictionary<string, object?>
 *             {
 *                 ["effect"] = "deny",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyDefinition(ctx, "policyDefinition", &authorization.PolicyDefinitionArgs{
 * 			Description: pulumi.String("Force resource names to begin with given 'prefix' and/or end with given 'suffix'"),
 * 			DisplayName: pulumi.String("Enforce resource naming convention"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"category": "Naming",
 * 			}),
 * 			Mode: pulumi.String("All"),
 * 			Parameters: authorization.ParameterDefinitionsValueMap{
 * 				"prefix": &authorization.ParameterDefinitionsValueArgs{
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("Resource name prefix"),
 * 						DisplayName: pulumi.String("Prefix"),
 * 					},
 * 					Type: pulumi.String(authorization.ParameterTypeString),
 * 				},
 * 				"suffix": &authorization.ParameterDefinitionsValueArgs{
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("Resource name suffix"),
 * 						DisplayName: pulumi.String("Suffix"),
 * 					},
 * 					Type: pulumi.String(authorization.ParameterTypeString),
 * 				},
 * 			},
 * 			PolicyDefinitionName: pulumi.String("ResourceNaming"),
 * 			PolicyRule: pulumi.Any(map[string]interface{}{
 * 				"if": map[string]interface{}{
 * 					"not": map[string]interface{}{
 * 						"field": "name",
 * 						"like":  "[concat(parameters('prefix'), '*', parameters('suffix'))]",
 * 					},
 * 				},
 * 				"then": map[string]interface{}{
 * 					"effect": "deny",
 * 				},
 * 			}),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyDefinition;
 * import com.pulumi.azurenative.authorization.PolicyDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyDefinition = new PolicyDefinition("policyDefinition", PolicyDefinitionArgs.builder()
 *             .description("Force resource names to begin with given 'prefix' and/or end with given 'suffix'")
 *             .displayName("Enforce resource naming convention")
 *             .metadata(Map.of("category", "Naming"))
 *             .mode("All")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("prefix", Map.ofEntries(
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("description", "Resource name prefix"),
 *                         Map.entry("displayName", "Prefix")
 *                     )),
 *                     Map.entry("type", "String")
 *                 )),
 *                 Map.entry("suffix", Map.ofEntries(
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("description", "Resource name suffix"),
 *                         Map.entry("displayName", "Suffix")
 *                     )),
 *                     Map.entry("type", "String")
 *                 ))
 *             ))
 *             .policyDefinitionName("ResourceNaming")
 *             .policyRule(Map.ofEntries(
 *                 Map.entry("if", Map.of("not", Map.ofEntries(
 *                     Map.entry("field", "name"),
 *                     Map.entry("like", "[concat(parameters('prefix'), '*', parameters('suffix'))]")
 *                 ))),
 *                 Map.entry("then", Map.of("effect", "deny"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy definition with advanced parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyDefinition = new AzureNative.Authorization.PolicyDefinition("policyDefinition", new()
 *     {
 *         Description = "Audit enabling of logs and retain them up to a year. This enables recreation of activity trails for investigation purposes when a security incident occurs or your network is compromised",
 *         DisplayName = "Event Hubs should have diagnostic logging enabled",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["category"] = "Event Hub",
 *         },
 *         Mode = "Indexed",
 *         Parameters =
 *         {
 *             { "requiredRetentionDays", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 AllowedValues = new[]
 *                 {
 *                     0,
 *                     30,
 *                     90,
 *                     180,
 *                     365,
 *                 },
 *                 DefaultValue = 365,
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "The required diagnostic logs retention in days",
 *                     DisplayName = "Required retention (days)",
 *                 },
 *                 Type = AzureNative.Authorization.ParameterType.Integer,
 *             } },
 *         },
 *         PolicyDefinitionName = "EventHubDiagnosticLogs",
 *         PolicyRule = new Dictionary<string, object?>
 *         {
 *             ["if"] = new Dictionary<string, object?>
 *             {
 *                 ["equals"] = "Microsoft.EventHub/namespaces",
 *                 ["field"] = "type",
 *             },
 *             ["then"] = new Dictionary<string, object?>
 *             {
 *                 ["details"] = new Dictionary<string, object?>
 *                 {
 *                     ["existenceCondition"] = new Dictionary<string, object?>
 *                     {
 *                         ["allOf"] = new[]
 *                         {
 *                             new Dictionary<string, object?>
 *                             {
 *                                 ["equals"] = "true",
 *                                 ["field"] = "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.enabled",
 *                             },
 *                             new Dictionary<string, object?>
 *                             {
 *                                 ["equals"] = "[parameters('requiredRetentionDays')]",
 *                                 ["field"] = "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.days",
 *                             },
 *                         },
 *                     },
 *                     ["type"] = "Microsoft.Insights/diagnosticSettings",
 *                 },
 *                 ["effect"] = "AuditIfNotExists",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyDefinition(ctx, "policyDefinition", &authorization.PolicyDefinitionArgs{
 * 			Description: pulumi.String("Audit enabling of logs and retain them up to a year. This enables recreation of activity trails for investigation purposes when a security incident occurs or your network is compromised"),
 * 			DisplayName: pulumi.String("Event Hubs should have diagnostic logging enabled"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"category": "Event Hub",
 * 			}),
 * 			Mode: pulumi.String("Indexed"),
 * 			Parameters: authorization.ParameterDefinitionsValueMap{
 * 				"requiredRetentionDays": &authorization.ParameterDefinitionsValueArgs{
 * 					AllowedValues: pulumi.Array{
 * 						pulumi.Any(0),
 * 						pulumi.Any(30),
 * 						pulumi.Any(90),
 * 						pulumi.Any(180),
 * 						pulumi.Any(365),
 * 					},
 * 					DefaultValue: pulumi.Any(365),
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("The required diagnostic logs retention in days"),
 * 						DisplayName: pulumi.String("Required retention (days)"),
 * 					},
 * 					Type: pulumi.String(authorization.ParameterTypeInteger),
 * 				},
 * 			},
 * 			PolicyDefinitionName: pulumi.String("EventHubDiagnosticLogs"),
 * 			PolicyRule: pulumi.Any(map[string]interface{}{
 * 				"if": map[string]interface{}{
 * 					"equals": "Microsoft.EventHub/namespaces",
 * 					"field":  "type",
 * 				},
 * 				"then": map[string]interface{}{
 * 					"details": map[string]interface{}{
 * 						"existenceCondition": map[string]interface{}{
 * 							"allOf": []map[string]interface{}{
 * 								map[string]interface{}{
 * 									"equals": "true",
 * 									"field":  "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.enabled",
 * 								},
 * 								map[string]interface{}{
 * 									"equals": "[parameters('requiredRetentionDays')]",
 * 									"field":  "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.days",
 * 								},
 * 							},
 * 						},
 * 						"type": "Microsoft.Insights/diagnosticSettings",
 * 					},
 * 					"effect": "AuditIfNotExists",
 * 				},
 * 			}),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyDefinition;
 * import com.pulumi.azurenative.authorization.PolicyDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyDefinition = new PolicyDefinition("policyDefinition", PolicyDefinitionArgs.builder()
 *             .description("Audit enabling of logs and retain them up to a year. This enables recreation of activity trails for investigation purposes when a security incident occurs or your network is compromised")
 *             .displayName("Event Hubs should have diagnostic logging enabled")
 *             .metadata(Map.of("category", "Event Hub"))
 *             .mode("Indexed")
 *             .parameters(Map.of("requiredRetentionDays", Map.ofEntries(
 *                 Map.entry("allowedValues",
 *                     0,
 *                     30,
 *                     90,
 *                     180,
 *                     365),
 *                 Map.entry("defaultValue", 365),
 *                 Map.entry("metadata", Map.ofEntries(
 *                     Map.entry("description", "The required diagnostic logs retention in days"),
 *                     Map.entry("displayName", "Required retention (days)")
 *                 )),
 *                 Map.entry("type", "Integer")
 *             )))
 *             .policyDefinitionName("EventHubDiagnosticLogs")
 *             .policyRule(Map.ofEntries(
 *                 Map.entry("if", Map.ofEntries(
 *                     Map.entry("equals", "Microsoft.EventHub/namespaces"),
 *                     Map.entry("field", "type")
 *                 )),
 *                 Map.entry("then", Map.ofEntries(
 *                     Map.entry("details", Map.ofEntries(
 *                         Map.entry("existenceCondition", Map.of("allOf",
 *                             Map.ofEntries(
 *                                 Map.entry("equals", "true"),
 *                                 Map.entry("field", "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.enabled")
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("equals", "[parameters('requiredRetentionDays')]"),
 *                                 Map.entry("field", "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.days")
 *                             ))),
 *                         Map.entry("type", "Microsoft.Insights/diagnosticSettings")
 *                     )),
 *                     Map.entry("effect", "AuditIfNotExists")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicyDefinition ResourceNaming /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}
 * ```
 */
public class PolicyDefinition internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.PolicyDefinition,
) : KotlinCustomResource(javaResource, PolicyDefinitionMapper) {
    /**
     * The policy definition description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the policy definition.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     */
    public val mode: Output<String>?
        get() = javaResource.mode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the policy definition.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    public val parameters: Output<Map<String, ParameterDefinitionsValueResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            parameterDefinitionsValueResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The policy rule.
     */
    public val policyRule: Output<Any>?
        get() = javaResource.policyRule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    public val policyType: Output<String>?
        get() = javaResource.policyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource (Microsoft.Authorization/policyDefinitions).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicyDefinitionMapper : ResourceMapper<PolicyDefinition> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.PolicyDefinition::class == javaResource::class

    override fun map(javaResource: Resource): PolicyDefinition = PolicyDefinition(
        javaResource as
            com.pulumi.azurenative.authorization.PolicyDefinition,
    )
}

/**
 * @see [PolicyDefinition].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyDefinition].
 */
public suspend fun policyDefinition(
    name: String,
    block: suspend PolicyDefinitionResourceBuilder.() -> Unit,
): PolicyDefinition {
    val builder = PolicyDefinitionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyDefinition].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyDefinition(name: String): PolicyDefinition {
    val builder = PolicyDefinitionResourceBuilder()
    builder.name(name)
    return builder.build()
}
