@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.PolicyDefinitionArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.PolicyType
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The policy definition.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2020-09-01.
 * Other available API versions: 2016-04-01, 2018-05-01, 2019-06-01, 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy definition
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyDefinition = new AzureNative.Authorization.PolicyDefinition("policyDefinition", new()
 *     {
 *         Description = "Force resource names to begin with given 'prefix' and/or end with given 'suffix'",
 *         DisplayName = "Enforce resource naming convention",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["category"] = "Naming",
 *         },
 *         Mode = "All",
 *         Parameters =
 *         {
 *             { "prefix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "Resource name prefix",
 *                     DisplayName = "Prefix",
 *                 },
 *                 Type = AzureNative.Authorization.ParameterType.String,
 *             } },
 *             { "suffix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "Resource name suffix",
 *                     DisplayName = "Suffix",
 *                 },
 *                 Type = AzureNative.Authorization.ParameterType.String,
 *             } },
 *         },
 *         PolicyDefinitionName = "ResourceNaming",
 *         PolicyRule = new Dictionary<string, object?>
 *         {
 *             ["if"] = new Dictionary<string, object?>
 *             {
 *                 ["not"] = new Dictionary<string, object?>
 *                 {
 *                     ["field"] = "name",
 *                     ["like"] = "[concat(parameters('prefix'), '*', parameters('suffix'))]",
 *                 },
 *             },
 *             ["then"] = new Dictionary<string, object?>
 *             {
 *                 ["effect"] = "deny",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyDefinition(ctx, "policyDefinition", &authorization.PolicyDefinitionArgs{
 * 			Description: pulumi.String("Force resource names to begin with given 'prefix' and/or end with given 'suffix'"),
 * 			DisplayName: pulumi.String("Enforce resource naming convention"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"category": "Naming",
 * 			}),
 * 			Mode: pulumi.String("All"),
 * 			Parameters: authorization.ParameterDefinitionsValueMap{
 * 				"prefix": &authorization.ParameterDefinitionsValueArgs{
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("Resource name prefix"),
 * 						DisplayName: pulumi.String("Prefix"),
 * 					},
 * 					Type: pulumi.String(authorization.ParameterTypeString),
 * 				},
 * 				"suffix": &authorization.ParameterDefinitionsValueArgs{
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("Resource name suffix"),
 * 						DisplayName: pulumi.String("Suffix"),
 * 					},
 * 					Type: pulumi.String(authorization.ParameterTypeString),
 * 				},
 * 			},
 * 			PolicyDefinitionName: pulumi.String("ResourceNaming"),
 * 			PolicyRule: pulumi.Any(map[string]interface{}{
 * 				"if": map[string]interface{}{
 * 					"not": map[string]interface{}{
 * 						"field": "name",
 * 						"like":  "[concat(parameters('prefix'), '*', parameters('suffix'))]",
 * 					},
 * 				},
 * 				"then": map[string]interface{}{
 * 					"effect": "deny",
 * 				},
 * 			}),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyDefinition;
 * import com.pulumi.azurenative.authorization.PolicyDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyDefinition = new PolicyDefinition("policyDefinition", PolicyDefinitionArgs.builder()
 *             .description("Force resource names to begin with given 'prefix' and/or end with given 'suffix'")
 *             .displayName("Enforce resource naming convention")
 *             .metadata(Map.of("category", "Naming"))
 *             .mode("All")
 *             .parameters(Map.ofEntries(
 *                 Map.entry("prefix", Map.ofEntries(
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("description", "Resource name prefix"),
 *                         Map.entry("displayName", "Prefix")
 *                     )),
 *                     Map.entry("type", "String")
 *                 )),
 *                 Map.entry("suffix", Map.ofEntries(
 *                     Map.entry("metadata", Map.ofEntries(
 *                         Map.entry("description", "Resource name suffix"),
 *                         Map.entry("displayName", "Suffix")
 *                     )),
 *                     Map.entry("type", "String")
 *                 ))
 *             ))
 *             .policyDefinitionName("ResourceNaming")
 *             .policyRule(Map.ofEntries(
 *                 Map.entry("if", Map.of("not", Map.ofEntries(
 *                     Map.entry("field", "name"),
 *                     Map.entry("like", "[concat(parameters('prefix'), '*', parameters('suffix'))]")
 *                 ))),
 *                 Map.entry("then", Map.of("effect", "deny"))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy definition with advanced parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyDefinition = new AzureNative.Authorization.PolicyDefinition("policyDefinition", new()
 *     {
 *         Description = "Audit enabling of logs and retain them up to a year. This enables recreation of activity trails for investigation purposes when a security incident occurs or your network is compromised",
 *         DisplayName = "Event Hubs should have diagnostic logging enabled",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["category"] = "Event Hub",
 *         },
 *         Mode = "Indexed",
 *         Parameters =
 *         {
 *             { "requiredRetentionDays", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 AllowedValues = new[]
 *                 {
 *                     0,
 *                     30,
 *                     90,
 *                     180,
 *                     365,
 *                 },
 *                 DefaultValue = 365,
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     Description = "The required diagnostic logs retention in days",
 *                     DisplayName = "Required retention (days)",
 *                 },
 *                 Type = AzureNative.Authorization.ParameterType.Integer,
 *             } },
 *         },
 *         PolicyDefinitionName = "EventHubDiagnosticLogs",
 *         PolicyRule = new Dictionary<string, object?>
 *         {
 *             ["if"] = new Dictionary<string, object?>
 *             {
 *                 ["equals"] = "Microsoft.EventHub/namespaces",
 *                 ["field"] = "type",
 *             },
 *             ["then"] = new Dictionary<string, object?>
 *             {
 *                 ["details"] = new Dictionary<string, object?>
 *                 {
 *                     ["existenceCondition"] = new Dictionary<string, object?>
 *                     {
 *                         ["allOf"] = new[]
 *                         {
 *                             new Dictionary<string, object?>
 *                             {
 *                                 ["equals"] = "true",
 *                                 ["field"] = "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.enabled",
 *                             },
 *                             new Dictionary<string, object?>
 *                             {
 *                                 ["equals"] = "[parameters('requiredRetentionDays')]",
 *                                 ["field"] = "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.days",
 *                             },
 *                         },
 *                     },
 *                     ["type"] = "Microsoft.Insights/diagnosticSettings",
 *                 },
 *                 ["effect"] = "AuditIfNotExists",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyDefinition(ctx, "policyDefinition", &authorization.PolicyDefinitionArgs{
 * 			Description: pulumi.String("Audit enabling of logs and retain them up to a year. This enables recreation of activity trails for investigation purposes when a security incident occurs or your network is compromised"),
 * 			DisplayName: pulumi.String("Event Hubs should have diagnostic logging enabled"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"category": "Event Hub",
 * 			}),
 * 			Mode: pulumi.String("Indexed"),
 * 			Parameters: authorization.ParameterDefinitionsValueMap{
 * 				"requiredRetentionDays": &authorization.ParameterDefinitionsValueArgs{
 * 					AllowedValues: pulumi.Array{
 * 						pulumi.Any(0),
 * 						pulumi.Any(30),
 * 						pulumi.Any(90),
 * 						pulumi.Any(180),
 * 						pulumi.Any(365),
 * 					},
 * 					DefaultValue: pulumi.Any(365),
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						Description: pulumi.String("The required diagnostic logs retention in days"),
 * 						DisplayName: pulumi.String("Required retention (days)"),
 * 					},
 * 					Type: pulumi.String(authorization.ParameterTypeInteger),
 * 				},
 * 			},
 * 			PolicyDefinitionName: pulumi.String("EventHubDiagnosticLogs"),
 * 			PolicyRule: pulumi.Any(map[string]interface{}{
 * 				"if": map[string]interface{}{
 * 					"equals": "Microsoft.EventHub/namespaces",
 * 					"field":  "type",
 * 				},
 * 				"then": map[string]interface{}{
 * 					"details": map[string]interface{}{
 * 						"existenceCondition": map[string]interface{}{
 * 							"allOf": []map[string]interface{}{
 * 								map[string]interface{}{
 * 									"equals": "true",
 * 									"field":  "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.enabled",
 * 								},
 * 								map[string]interface{}{
 * 									"equals": "[parameters('requiredRetentionDays')]",
 * 									"field":  "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.days",
 * 								},
 * 							},
 * 						},
 * 						"type": "Microsoft.Insights/diagnosticSettings",
 * 					},
 * 					"effect": "AuditIfNotExists",
 * 				},
 * 			}),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyDefinition;
 * import com.pulumi.azurenative.authorization.PolicyDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyDefinition = new PolicyDefinition("policyDefinition", PolicyDefinitionArgs.builder()
 *             .description("Audit enabling of logs and retain them up to a year. This enables recreation of activity trails for investigation purposes when a security incident occurs or your network is compromised")
 *             .displayName("Event Hubs should have diagnostic logging enabled")
 *             .metadata(Map.of("category", "Event Hub"))
 *             .mode("Indexed")
 *             .parameters(Map.of("requiredRetentionDays", Map.ofEntries(
 *                 Map.entry("allowedValues",
 *                     0,
 *                     30,
 *                     90,
 *                     180,
 *                     365),
 *                 Map.entry("defaultValue", 365),
 *                 Map.entry("metadata", Map.ofEntries(
 *                     Map.entry("description", "The required diagnostic logs retention in days"),
 *                     Map.entry("displayName", "Required retention (days)")
 *                 )),
 *                 Map.entry("type", "Integer")
 *             )))
 *             .policyDefinitionName("EventHubDiagnosticLogs")
 *             .policyRule(Map.ofEntries(
 *                 Map.entry("if", Map.ofEntries(
 *                     Map.entry("equals", "Microsoft.EventHub/namespaces"),
 *                     Map.entry("field", "type")
 *                 )),
 *                 Map.entry("then", Map.ofEntries(
 *                     Map.entry("details", Map.ofEntries(
 *                         Map.entry("existenceCondition", Map.of("allOf",
 *                             Map.ofEntries(
 *                                 Map.entry("equals", "true"),
 *                                 Map.entry("field", "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.enabled")
 *                             ),
 *                             Map.ofEntries(
 *                                 Map.entry("equals", "[parameters('requiredRetentionDays')]"),
 *                                 Map.entry("field", "Microsoft.Insights/diagnosticSettings/logs[*].retentionPolicy.days")
 *                             ))),
 *                         Map.entry("type", "Microsoft.Insights/diagnosticSettings")
 *                     )),
 *                     Map.entry("effect", "AuditIfNotExists")
 *                 ))
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicyDefinition ResourceNaming /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policyDefinitions/{policyDefinitionName}
 * ```
 * @property description The policy definition description.
 * @property displayName The display name of the policy definition.
 * @property metadata The policy definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
 * @property mode The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
 * @property parameters The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
 * @property policyDefinitionName The name of the policy definition to create.
 * @property policyRule The policy rule.
 * @property policyType The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
 */
public data class PolicyDefinitionArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val mode: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null,
    public val policyDefinitionName: Output<String>? = null,
    public val policyRule: Output<Any>? = null,
    public val policyType: Output<Either<String, PolicyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.PolicyDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.PolicyDefinitionArgs =
        com.pulumi.azurenative.authorization.PolicyDefinitionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policyDefinitionName(policyDefinitionName?.applyValue({ args0 -> args0 }))
            .policyRule(policyRule?.applyValue({ args0 -> args0 }))
            .policyType(
                policyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicyDefinitionArgs].
 */
@PulumiTagMarker
public class PolicyDefinitionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var mode: Output<String>? = null

    private var parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null

    private var policyDefinitionName: Output<String>? = null

    private var policyRule: Output<Any>? = null

    private var policyType: Output<Either<String, PolicyType>>? = null

    /**
     * @param value The policy definition description.
     */
    @JvmName("bokdtwpfviqemuuk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the policy definition.
     */
    @JvmName("cqgsklfhdqccdtwl")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The policy definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("wrlfkievawjotmwi")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     */
    @JvmName("icxoviikqumjrkaa")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    @JvmName("auajbtbbggyhlipv")
    public suspend fun parameters(`value`: Output<Map<String, ParameterDefinitionsValueArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The name of the policy definition to create.
     */
    @JvmName("hhuehyighqauragx")
    public suspend fun policyDefinitionName(`value`: Output<String>) {
        this.policyDefinitionName = value
    }

    /**
     * @param value The policy rule.
     */
    @JvmName("buravewoxundmeut")
    public suspend fun policyRule(`value`: Output<Any>) {
        this.policyRule = value
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("scycddckmgtwauyh")
    public suspend fun policyType(`value`: Output<Either<String, PolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value The policy definition description.
     */
    @JvmName("ylvfhdnftqopkrwh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the policy definition.
     */
    @JvmName("wgukxmcuddpicayt")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The policy definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("kxmuqrsjglrpmfck")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The policy definition mode. Some examples are All, Indexed, Microsoft.KeyVault.Data.
     */
    @JvmName("rdybsfkjdwrddvyk")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    @JvmName("hwyxwkadgvtrikao")
    public suspend fun parameters(`value`: Map<String, ParameterDefinitionsValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    @JvmName("rxvuoytcjpxinnrr")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterDefinitionsValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterDefinitionsValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The parameter definitions for parameters used in the policy rule. The keys are the parameter names.
     */
    @JvmName("lgehjnmheecugfud")
    public fun parameters(vararg values: Pair<String, ParameterDefinitionsValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name of the policy definition to create.
     */
    @JvmName("ywkdoyfpaqitadto")
    public suspend fun policyDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionName = mapped
    }

    /**
     * @param value The policy rule.
     */
    @JvmName("saghikmdvlsxovee")
    public suspend fun policyRule(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyRule = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("fbnkgyjnvqeftduv")
    public suspend fun policyType(`value`: Either<String, PolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("kppfqxcjfcgkrrlu")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("otfhxwivpmvhbnmb")
    public fun policyType(`value`: PolicyType) {
        val toBeMapped = Either.ofRight<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    internal fun build(): PolicyDefinitionArgs = PolicyDefinitionArgs(
        description = description,
        displayName = displayName,
        metadata = metadata,
        mode = mode,
        parameters = parameters,
        policyDefinitionName = policyDefinitionName,
        policyRule = policyRule,
        policyType = policyType,
    )
}
