@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.ResourceSelectorResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.authorization.kotlin.outputs.ResourceSelectorResponse.Companion.toKotlin as resourceSelectorResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PolicyExemption].
 */
@PulumiTagMarker
public class PolicyExemptionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyExemptionArgs = PolicyExemptionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyExemptionArgsBuilder.() -> Unit) {
        val builder = PolicyExemptionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicyExemption {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.PolicyExemption(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicyExemption(builtJavaResource)
    }
}

/**
 * The policy exemption.
 * Azure REST API version: 2022-07-01-preview. Prior API version in Azure Native 1.x: 2020-07-01-preview.
 * ## Example Usage
 * ### Create or update a policy exemption
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyExemption = new AzureNative.Authorization.PolicyExemption("policyExemption", new()
 *     {
 *         Description = "Exempt demo cluster from limit sku",
 *         DisplayName = "Exempt demo cluster",
 *         ExemptionCategory = AzureNative.Authorization.ExemptionCategory.Waiver,
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["reason"] = "Temporary exemption for a expensive VM demo",
 *         },
 *         PolicyAssignmentId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement",
 *         PolicyDefinitionReferenceIds = new[]
 *         {
 *             "Limit_Skus",
 *         },
 *         PolicyExemptionName = "DemoExpensiveVM",
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyExemption(ctx, "policyExemption", &authorization.PolicyExemptionArgs{
 * 			Description:       pulumi.String("Exempt demo cluster from limit sku"),
 * 			DisplayName:       pulumi.String("Exempt demo cluster"),
 * 			ExemptionCategory: pulumi.String(authorization.ExemptionCategoryWaiver),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"reason": "Temporary exemption for a expensive VM demo",
 * 			}),
 * 			PolicyAssignmentId: pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement"),
 * 			PolicyDefinitionReferenceIds: pulumi.StringArray{
 * 				pulumi.String("Limit_Skus"),
 * 			},
 * 			PolicyExemptionName: pulumi.String("DemoExpensiveVM"),
 * 			Scope:               pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyExemption;
 * import com.pulumi.azurenative.authorization.PolicyExemptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyExemption = new PolicyExemption("policyExemption", PolicyExemptionArgs.builder()
 *             .description("Exempt demo cluster from limit sku")
 *             .displayName("Exempt demo cluster")
 *             .exemptionCategory("Waiver")
 *             .metadata(Map.of("reason", "Temporary exemption for a expensive VM demo"))
 *             .policyAssignmentId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement")
 *             .policyDefinitionReferenceIds("Limit_Skus")
 *             .policyExemptionName("DemoExpensiveVM")
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a policy exemption with resource selectors
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policyExemption = new AzureNative.Authorization.PolicyExemption("policyExemption", new()
 *     {
 *         AssignmentScopeValidation = AzureNative.Authorization.AssignmentScopeValidation.Default,
 *         Description = "Exempt demo cluster from limit sku",
 *         DisplayName = "Exempt demo cluster",
 *         ExemptionCategory = AzureNative.Authorization.ExemptionCategory.Waiver,
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["reason"] = "Temporary exemption for a expensive VM demo",
 *         },
 *         PolicyAssignmentId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement",
 *         PolicyDefinitionReferenceIds = new[]
 *         {
 *             "Limit_Skus",
 *         },
 *         PolicyExemptionName = "DemoExpensiveVM",
 *         ResourceSelectors = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.ResourceSelectorArgs
 *             {
 *                 Name = "SDPRegions",
 *                 Selectors = new[]
 *                 {
 *                     new AzureNative.Authorization.Inputs.SelectorArgs
 *                     {
 *                         In = new[]
 *                         {
 *                             "eastus2euap",
 *                             "centraluseuap",
 *                         },
 *                         Kind = AzureNative.Authorization.SelectorKind.ResourceLocation,
 *                     },
 *                 },
 *             },
 *         },
 *         Scope = "subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicyExemption(ctx, "policyExemption", &authorization.PolicyExemptionArgs{
 * 			AssignmentScopeValidation: pulumi.String(authorization.AssignmentScopeValidationDefault),
 * 			Description:               pulumi.String("Exempt demo cluster from limit sku"),
 * 			DisplayName:               pulumi.String("Exempt demo cluster"),
 * 			ExemptionCategory:         pulumi.String(authorization.ExemptionCategoryWaiver),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"reason": "Temporary exemption for a expensive VM demo",
 * 			}),
 * 			PolicyAssignmentId: pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement"),
 * 			PolicyDefinitionReferenceIds: pulumi.StringArray{
 * 				pulumi.String("Limit_Skus"),
 * 			},
 * 			PolicyExemptionName: pulumi.String("DemoExpensiveVM"),
 * 			ResourceSelectors: authorization.ResourceSelectorArray{
 * 				&authorization.ResourceSelectorArgs{
 * 					Name: pulumi.String("SDPRegions"),
 * 					Selectors: authorization.SelectorArray{
 * 						&authorization.SelectorArgs{
 * 							In: pulumi.StringArray{
 * 								pulumi.String("eastus2euap"),
 * 								pulumi.String("centraluseuap"),
 * 							},
 * 							Kind: pulumi.String(authorization.SelectorKindResourceLocation),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Scope: pulumi.String("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicyExemption;
 * import com.pulumi.azurenative.authorization.PolicyExemptionArgs;
 * import com.pulumi.azurenative.authorization.inputs.ResourceSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policyExemption = new PolicyExemption("policyExemption", PolicyExemptionArgs.builder()
 *             .assignmentScopeValidation("Default")
 *             .description("Exempt demo cluster from limit sku")
 *             .displayName("Exempt demo cluster")
 *             .exemptionCategory("Waiver")
 *             .metadata(Map.of("reason", "Temporary exemption for a expensive VM demo"))
 *             .policyAssignmentId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyAssignments/CostManagement")
 *             .policyDefinitionReferenceIds("Limit_Skus")
 *             .policyExemptionName("DemoExpensiveVM")
 *             .resourceSelectors(ResourceSelectorArgs.builder()
 *                 .name("SDPRegions")
 *                 .selectors(SelectorArgs.builder()
 *                     .in(
 *                         "eastus2euap",
 *                         "centraluseuap")
 *                     .kind("resourceLocation")
 *                     .build())
 *                 .build())
 *             .scope("subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/resourceGroups/demoCluster")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicyExemption DemoExpensiveVM /{scope}/providers/Microsoft.Authorization/policyExemptions/{policyExemptionName}
 * ```
 */
public class PolicyExemption internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.PolicyExemption,
) : KotlinCustomResource(javaResource, PolicyExemptionMapper) {
    /**
     * The option whether validate the exemption is at or under the assignment scope.
     */
    public val assignmentScopeValidation: Output<String>?
        get() = javaResource.assignmentScopeValidation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the policy exemption.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the policy exemption.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy exemption category. Possible values are Waiver and Mitigated.
     */
    public val exemptionCategory: Output<String>
        get() = javaResource.exemptionCategory().applyValue({ args0 -> args0 })

    /**
     * The expiration date and time (in UTC ISO 8601 format yyyy-MM-ddTHH:mm:ssZ) of the policy exemption.
     */
    public val expiresOn: Output<String>?
        get() = javaResource.expiresOn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The policy exemption metadata. Metadata is an open ended object and is typically a collection of key value pairs.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the policy exemption.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ID of the policy assignment that is being exempted.
     */
    public val policyAssignmentId: Output<String>
        get() = javaResource.policyAssignmentId().applyValue({ args0 -> args0 })

    /**
     * The policy definition reference ID list when the associated policy assignment is an assignment of a policy set definition.
     */
    public val policyDefinitionReferenceIds: Output<List<String>>?
        get() = javaResource.policyDefinitionReferenceIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The resource selector list to filter policies by resource properties.
     */
    public val resourceSelectors: Output<List<ResourceSelectorResponse>>?
        get() = javaResource.resourceSelectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        resourceSelectorResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource (Microsoft.Authorization/policyExemptions).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PolicyExemptionMapper : ResourceMapper<PolicyExemption> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.PolicyExemption::class == javaResource::class

    override fun map(javaResource: Resource): PolicyExemption = PolicyExemption(
        javaResource as
            com.pulumi.azurenative.authorization.PolicyExemption,
    )
}

/**
 * @see [PolicyExemption].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicyExemption].
 */
public suspend fun policyExemption(
    name: String,
    block: suspend PolicyExemptionResourceBuilder.() -> Unit,
): PolicyExemption {
    val builder = PolicyExemptionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicyExemption].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policyExemption(name: String): PolicyExemption {
    val builder = PolicyExemptionResourceBuilder()
    builder.name(name)
    return builder.build()
}
