@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.PolicySetDefinitionVersionArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.PolicyType
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.ParameterDefinitionsValueArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionGroupArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionGroupArgsBuilder
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionReferenceArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyDefinitionReferenceArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The policy set definition version.
 * Azure REST API version: 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy set definition version
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policySetDefinitionVersion = new AzureNative.Authorization.PolicySetDefinitionVersion("policySetDefinitionVersion", new()
 *     {
 *         Description = "Policies to enforce low cost storage SKUs",
 *         DisplayName = "Cost Management",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["category"] = "Cost Management",
 *         },
 *         Parameters =
 *         {
 *             { "namePrefix", new AzureNative.Authorization.Inputs.ParameterDefinitionsValueArgs
 *             {
 *                 DefaultValue = "myPrefix",
 *                 Metadata = new AzureNative.Authorization.Inputs.ParameterDefinitionsValueMetadataArgs
 *                 {
 *                     DisplayName = "Prefix to enforce on resource names",
 *                 },
 *                 Type = AzureNative.Authorization.ParameterType.String,
 *             } },
 *         },
 *         PolicyDefinitionVersion = "1.2.1",
 *         PolicyDefinitions = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "listOfAllowedSKUs", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = new[]
 *                         {
 *                             "Standard_GRS",
 *                             "Standard_LRS",
 *                         },
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1",
 *                 PolicyDefinitionReferenceId = "Limit_Skus",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "[parameters('namePrefix')]",
 *                     } },
 *                     { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "-LC",
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *                 PolicyDefinitionReferenceId = "Resource_Naming",
 *             },
 *         },
 *         PolicySetDefinitionName = "CostManagement",
 *         Version = "1.2.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicySetDefinitionVersion(ctx, "policySetDefinitionVersion", &authorization.PolicySetDefinitionVersionArgs{
 * 			Description: pulumi.String("Policies to enforce low cost storage SKUs"),
 * 			DisplayName: pulumi.String("Cost Management"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"category": "Cost Management",
 * 			}),
 * 			Parameters: authorization.ParameterDefinitionsValueMap{
 * 				"namePrefix": &authorization.ParameterDefinitionsValueArgs{
 * 					DefaultValue: pulumi.Any("myPrefix"),
 * 					Metadata: &authorization.ParameterDefinitionsValueMetadataArgs{
 * 						DisplayName: pulumi.String("Prefix to enforce on resource names"),
 * 					},
 * 					Type: pulumi.String(authorization.ParameterTypeString),
 * 				},
 * 			},
 * 			PolicyDefinitionVersion: pulumi.String("1.2.1"),
 * 			PolicyDefinitions: authorization.PolicyDefinitionReferenceArray{
 * 				&authorization.PolicyDefinitionReferenceArgs{
 * 					Parameters: authorization.ParameterValuesValueMap{
 * 						"listOfAllowedSKUs": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any{
 * 								"Standard_GRS",
 * 								"Standard_LRS",
 * 							},
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Limit_Skus"),
 * 				},
 * 				&authorization.PolicyDefinitionReferenceArgs{
 * 					Parameters: authorization.ParameterValuesValueMap{
 * 						"prefix": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any("[parameters('namePrefix')]"),
 * 						},
 * 						"suffix": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any("-LC"),
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Resource_Naming"),
 * 				},
 * 			},
 * 			PolicySetDefinitionName: pulumi.String("CostManagement"),
 * 			Version:                 pulumi.String("1.2.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionVersion;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionVersionArgs;
 * import com.pulumi.azurenative.authorization.inputs.PolicyDefinitionReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policySetDefinitionVersion = new PolicySetDefinitionVersion("policySetDefinitionVersion", PolicySetDefinitionVersionArgs.builder()
 *             .description("Policies to enforce low cost storage SKUs")
 *             .displayName("Cost Management")
 *             .metadata(Map.of("category", "Cost Management"))
 *             .parameters(Map.of("namePrefix", Map.ofEntries(
 *                 Map.entry("defaultValue", "myPrefix"),
 *                 Map.entry("metadata", Map.of("displayName", "Prefix to enforce on resource names")),
 *                 Map.entry("type", "String")
 *             )))
 *             .policyDefinitionVersion("1.2.1")
 *             .policyDefinitions(
 *                 PolicyDefinitionReferenceArgs.builder()
 *                     .parameters(Map.of("listOfAllowedSKUs", Map.of("value",
 *                         "Standard_GRS",
 *                         "Standard_LRS")))
 *                     .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1")
 *                     .policyDefinitionReferenceId("Limit_Skus")
 *                     .build(),
 *                 PolicyDefinitionReferenceArgs.builder()
 *                     .parameters(Map.ofEntries(
 *                         Map.entry("prefix", Map.of("value", "[parameters('namePrefix')]")),
 *                         Map.entry("suffix", Map.of("value", "-LC"))
 *                     ))
 *                     .policyDefinitionId("/subscriptions/ae640e6b-ba3e-4256-9d62-2993eecfa6f2/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming")
 *                     .policyDefinitionReferenceId("Resource_Naming")
 *                     .build())
 *             .policySetDefinitionName("CostManagement")
 *             .version("1.2.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicySetDefinitionVersion 1.2.1 /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions/{policyDefinitionVersion}
 * ```
 * @property description The policy set definition description.
 * @property displayName The display name of the policy set definition.
 * @property metadata The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
 * @property parameters The policy set definition parameters that can be used in policy definition references.
 * @property policyDefinitionGroups The metadata describing groups of policy definition references within the policy set definition.
 * @property policyDefinitionVersion The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
 * @property policyDefinitions An array of policy definition references.
 * @property policySetDefinitionName The name of the policy set definition.
 * @property policyType The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
 * @property version The policy set definition version in #.#.# format.
 */
public data class PolicySetDefinitionVersionArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null,
    public val policyDefinitionGroups: Output<List<PolicyDefinitionGroupArgs>>? = null,
    public val policyDefinitionVersion: Output<String>? = null,
    public val policyDefinitions: Output<List<PolicyDefinitionReferenceArgs>>? = null,
    public val policySetDefinitionName: Output<String>? = null,
    public val policyType: Output<Either<String, PolicyType>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.PolicySetDefinitionVersionArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.PolicySetDefinitionVersionArgs =
        com.pulumi.azurenative.authorization.PolicySetDefinitionVersionArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policyDefinitionGroups(
                policyDefinitionGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .policyDefinitionVersion(policyDefinitionVersion?.applyValue({ args0 -> args0 }))
            .policyDefinitions(
                policyDefinitions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .policySetDefinitionName(policySetDefinitionName?.applyValue({ args0 -> args0 }))
            .policyType(
                policyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicySetDefinitionVersionArgs].
 */
@PulumiTagMarker
public class PolicySetDefinitionVersionArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterDefinitionsValueArgs>>? = null

    private var policyDefinitionGroups: Output<List<PolicyDefinitionGroupArgs>>? = null

    private var policyDefinitionVersion: Output<String>? = null

    private var policyDefinitions: Output<List<PolicyDefinitionReferenceArgs>>? = null

    private var policySetDefinitionName: Output<String>? = null

    private var policyType: Output<Either<String, PolicyType>>? = null

    private var version: Output<String>? = null

    /**
     * @param value The policy set definition description.
     */
    @JvmName("hhkmupopatvqlyim")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The display name of the policy set definition.
     */
    @JvmName("qdqgqxedxfmmhhfc")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("fuvhkvbuhrgsowpv")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("xwedcyiqhgwabnet")
    public suspend fun parameters(`value`: Output<Map<String, ParameterDefinitionsValueArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("mumncifdugnqgpwy")
    public suspend fun policyDefinitionGroups(`value`: Output<List<PolicyDefinitionGroupArgs>>) {
        this.policyDefinitionGroups = value
    }

    @JvmName("jhtgdoqfnxypllkc")
    public suspend fun policyDefinitionGroups(vararg values: Output<PolicyDefinitionGroupArgs>) {
        this.policyDefinitionGroups = Output.all(values.asList())
    }

    /**
     * @param values The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("nrudwqajyfvmmeba")
    public suspend fun policyDefinitionGroups(values: List<Output<PolicyDefinitionGroupArgs>>) {
        this.policyDefinitionGroups = Output.all(values)
    }

    /**
     * @param value The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     */
    @JvmName("jfjeykqmuqmluixw")
    public suspend fun policyDefinitionVersion(`value`: Output<String>) {
        this.policyDefinitionVersion = value
    }

    /**
     * @param value An array of policy definition references.
     */
    @JvmName("fveijnvcnxrxdlob")
    public suspend fun policyDefinitions(`value`: Output<List<PolicyDefinitionReferenceArgs>>) {
        this.policyDefinitions = value
    }

    @JvmName("ouidosccmmgcuekv")
    public suspend fun policyDefinitions(vararg values: Output<PolicyDefinitionReferenceArgs>) {
        this.policyDefinitions = Output.all(values.asList())
    }

    /**
     * @param values An array of policy definition references.
     */
    @JvmName("evvduuesgfsioach")
    public suspend fun policyDefinitions(values: List<Output<PolicyDefinitionReferenceArgs>>) {
        this.policyDefinitions = Output.all(values)
    }

    /**
     * @param value The name of the policy set definition.
     */
    @JvmName("guanrppjxkqcusll")
    public suspend fun policySetDefinitionName(`value`: Output<String>) {
        this.policySetDefinitionName = value
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("odpbmudcejagaodf")
    public suspend fun policyType(`value`: Output<Either<String, PolicyType>>) {
        this.policyType = value
    }

    /**
     * @param value The policy set definition version in #.#.# format.
     */
    @JvmName("nguepxmrcmxmbkmr")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The policy set definition description.
     */
    @JvmName("wnnalnwssebuiabw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The display name of the policy set definition.
     */
    @JvmName("ggxphnqmgbhfmpaw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    @JvmName("cpduxsqeegievdse")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("yaudtwmejspgxetb")
    public suspend fun parameters(`value`: Map<String, ParameterDefinitionsValueArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("aatdtwtljgyxuaxd")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterDefinitionsValueArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterDefinitionsValueArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values The policy set definition parameters that can be used in policy definition references.
     */
    @JvmName("odhyrwnqxbjdanwb")
    public fun parameters(vararg values: Pair<String, ParameterDefinitionsValueArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("epddckjqrtipjxtl")
    public suspend fun policyDefinitionGroups(`value`: List<PolicyDefinitionGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("pwyeqyxijutkfrjc")
    public suspend
    fun policyDefinitionGroups(argument: List<suspend PolicyDefinitionGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("bjiujfgsyhbpaakg")
    public suspend fun policyDefinitionGroups(
        vararg
        argument: suspend PolicyDefinitionGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param argument The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("jcyshoqunbvkjevj")
    public suspend
    fun policyDefinitionGroups(argument: suspend PolicyDefinitionGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PolicyDefinitionGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param values The metadata describing groups of policy definition references within the policy set definition.
     */
    @JvmName("lqgqoctwevlhpavv")
    public suspend fun policyDefinitionGroups(vararg values: PolicyDefinitionGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyDefinitionGroups = mapped
    }

    /**
     * @param value The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     */
    @JvmName("utuasbcbtatylbwn")
    public suspend fun policyDefinitionVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitionVersion = mapped
    }

    /**
     * @param value An array of policy definition references.
     */
    @JvmName("fdmfvvkwhbaudmbv")
    public suspend fun policyDefinitions(`value`: List<PolicyDefinitionReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("yyagobxscplvttuy")
    public suspend
    fun policyDefinitions(argument: List<suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("moasdavqmkpeihfc")
    public suspend fun policyDefinitions(
        vararg
        argument: suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param argument An array of policy definition references.
     */
    @JvmName("xlafthjlvqbeabxc")
    public suspend
    fun policyDefinitions(argument: suspend PolicyDefinitionReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PolicyDefinitionReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.policyDefinitions = mapped
    }

    /**
     * @param values An array of policy definition references.
     */
    @JvmName("qyamyltvpynaayrs")
    public suspend fun policyDefinitions(vararg values: PolicyDefinitionReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyDefinitions = mapped
    }

    /**
     * @param value The name of the policy set definition.
     */
    @JvmName("wbtkcyhnyfmwdkvs")
    public suspend fun policySetDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policySetDefinitionName = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("vpnrvvgggpraljqv")
    public suspend fun policyType(`value`: Either<String, PolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("mkyfyfkmldlpxrlj")
    public fun policyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    @JvmName("egntxwnbpevtntbj")
    public fun policyType(`value`: PolicyType) {
        val toBeMapped = Either.ofRight<String, PolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.policyType = mapped
    }

    /**
     * @param value The policy set definition version in #.#.# format.
     */
    @JvmName("vdsuahrebhrumtiu")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): PolicySetDefinitionVersionArgs = PolicySetDefinitionVersionArgs(
        description = description,
        displayName = displayName,
        metadata = metadata,
        parameters = parameters,
        policyDefinitionGroups = policyDefinitionGroups,
        policyDefinitionVersion = policyDefinitionVersion,
        policyDefinitions = policyDefinitions,
        policySetDefinitionName = policySetDefinitionName,
        policyType = policyType,
        version = version,
    )
}
