@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionGroupResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionReferenceResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.authorization.kotlin.outputs.ParameterDefinitionsValueResponse.Companion.toKotlin as parameterDefinitionsValueResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionGroupResponse.Companion.toKotlin as policyDefinitionGroupResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.PolicyDefinitionReferenceResponse.Companion.toKotlin as policyDefinitionReferenceResponseToKotlin
import com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [PolicySetDefinitionVersionAtManagementGroup].
 */
@PulumiTagMarker
public class PolicySetDefinitionVersionAtManagementGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicySetDefinitionVersionAtManagementGroupArgs =
        PolicySetDefinitionVersionAtManagementGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend PolicySetDefinitionVersionAtManagementGroupArgsBuilder.() -> Unit) {
        val builder = PolicySetDefinitionVersionAtManagementGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): PolicySetDefinitionVersionAtManagementGroup {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PolicySetDefinitionVersionAtManagementGroup(builtJavaResource)
    }
}

/**
 * The policy set definition version.
 * Azure REST API version: 2023-04-01.
 * ## Example Usage
 * ### Create or update a policy set definition version at management group level
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var policySetDefinitionVersionAtManagementGroup = new AzureNative.Authorization.PolicySetDefinitionVersionAtManagementGroup("policySetDefinitionVersionAtManagementGroup", new()
 *     {
 *         Description = "Policies to enforce low cost storage SKUs",
 *         DisplayName = "Cost Management",
 *         ManagementGroupName = "MyManagementGroup",
 *         Metadata = new Dictionary<string, object?>
 *         {
 *             ["category"] = "Cost Management",
 *         },
 *         PolicyDefinitionVersion = "1.2.1",
 *         PolicyDefinitions = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "listOfAllowedSKUs", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = new[]
 *                         {
 *                             "Standard_GRS",
 *                             "Standard_LRS",
 *                         },
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1",
 *                 PolicyDefinitionReferenceId = "Limit_Skus",
 *             },
 *             new AzureNative.Authorization.Inputs.PolicyDefinitionReferenceArgs
 *             {
 *                 Parameters =
 *                 {
 *                     { "prefix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "DeptA",
 *                     } },
 *                     { "suffix", new AzureNative.Authorization.Inputs.ParameterValuesValueArgs
 *                     {
 *                         Value = "-LC",
 *                     } },
 *                 },
 *                 PolicyDefinitionId = "/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming",
 *                 PolicyDefinitionReferenceId = "Resource_Naming",
 *             },
 *         },
 *         PolicySetDefinitionName = "CostManagement",
 *         Version = "1.2.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewPolicySetDefinitionVersionAtManagementGroup(ctx, "policySetDefinitionVersionAtManagementGroup", &authorization.PolicySetDefinitionVersionAtManagementGroupArgs{
 * 			Description:         pulumi.String("Policies to enforce low cost storage SKUs"),
 * 			DisplayName:         pulumi.String("Cost Management"),
 * 			ManagementGroupName: pulumi.String("MyManagementGroup"),
 * 			Metadata: pulumi.Any(map[string]interface{}{
 * 				"category": "Cost Management",
 * 			}),
 * 			PolicyDefinitionVersion: pulumi.String("1.2.1"),
 * 			PolicyDefinitions: authorization.PolicyDefinitionReferenceArray{
 * 				&authorization.PolicyDefinitionReferenceArgs{
 * 					Parameters: authorization.ParameterValuesValueMap{
 * 						"listOfAllowedSKUs": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any{
 * 								"Standard_GRS",
 * 								"Standard_LRS",
 * 							},
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Limit_Skus"),
 * 				},
 * 				&authorization.PolicyDefinitionReferenceArgs{
 * 					Parameters: authorization.ParameterValuesValueMap{
 * 						"prefix": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any("DeptA"),
 * 						},
 * 						"suffix": &authorization.ParameterValuesValueArgs{
 * 							Value: pulumi.Any("-LC"),
 * 						},
 * 					},
 * 					PolicyDefinitionId:          pulumi.String("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming"),
 * 					PolicyDefinitionReferenceId: pulumi.String("Resource_Naming"),
 * 				},
 * 			},
 * 			PolicySetDefinitionName: pulumi.String("CostManagement"),
 * 			Version:                 pulumi.String("1.2.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroup;
 * import com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroupArgs;
 * import com.pulumi.azurenative.authorization.inputs.PolicyDefinitionReferenceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var policySetDefinitionVersionAtManagementGroup = new PolicySetDefinitionVersionAtManagementGroup("policySetDefinitionVersionAtManagementGroup", PolicySetDefinitionVersionAtManagementGroupArgs.builder()
 *             .description("Policies to enforce low cost storage SKUs")
 *             .displayName("Cost Management")
 *             .managementGroupName("MyManagementGroup")
 *             .metadata(Map.of("category", "Cost Management"))
 *             .policyDefinitionVersion("1.2.1")
 *             .policyDefinitions(
 *                 PolicyDefinitionReferenceArgs.builder()
 *                     .parameters(Map.of("listOfAllowedSKUs", Map.of("value",
 *                         "Standard_GRS",
 *                         "Standard_LRS")))
 *                     .policyDefinitionId("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/7433c107-6db4-4ad1-b57a-a76dce0154a1")
 *                     .policyDefinitionReferenceId("Limit_Skus")
 *                     .build(),
 *                 PolicyDefinitionReferenceArgs.builder()
 *                     .parameters(Map.ofEntries(
 *                         Map.entry("prefix", Map.of("value", "DeptA")),
 *                         Map.entry("suffix", Map.of("value", "-LC"))
 *                     ))
 *                     .policyDefinitionId("/providers/Microsoft.Management/managementgroups/MyManagementGroup/providers/Microsoft.Authorization/policyDefinitions/ResourceNaming")
 *                     .policyDefinitionReferenceId("Resource_Naming")
 *                     .build())
 *             .policySetDefinitionName("CostManagement")
 *             .version("1.2.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:PolicySetDefinitionVersionAtManagementGroup CostManagement /providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Authorization/policySetDefinitions/{policySetDefinitionName}/versions/{policyDefinitionVersion}
 * ```
 */
public class PolicySetDefinitionVersionAtManagementGroup internal constructor(
    override val javaResource:
    com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroup,
) : KotlinCustomResource(javaResource, PolicySetDefinitionVersionAtManagementGroupMapper) {
    /**
     * The policy set definition description.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The display name of the policy set definition.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The policy set definition metadata.  Metadata is an open ended object and is typically a collection of key value pairs.
     */
    public val metadata: Output<Any>?
        get() = javaResource.metadata().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the policy set definition version.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The policy set definition parameters that can be used in policy definition references.
     */
    public val parameters: Output<Map<String, ParameterDefinitionsValueResponse>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(
                        args0.value.let({ args0 ->
                            parameterDefinitionsValueResponseToKotlin(args0)
                        }),
                    )
                }).toMap()
            }).orElse(null)
        })

    /**
     * The metadata describing groups of policy definition references within the policy set definition.
     */
    public val policyDefinitionGroups: Output<List<PolicyDefinitionGroupResponse>>?
        get() = javaResource.policyDefinitionGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        policyDefinitionGroupResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * An array of policy definition references.
     */
    public val policyDefinitions: Output<List<PolicyDefinitionReferenceResponse>>
        get() = javaResource.policyDefinitions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> policyDefinitionReferenceResponseToKotlin(args0) })
            })
        })

    /**
     * The type of policy definition. Possible values are NotSpecified, BuiltIn, Custom, and Static.
     */
    public val policyType: Output<String>?
        get() = javaResource.policyType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system metadata relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource (Microsoft.Authorization/policySetDefinitions/versions).
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The policy set definition version in #.#.# format.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object PolicySetDefinitionVersionAtManagementGroupMapper :
    ResourceMapper<PolicySetDefinitionVersionAtManagementGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroup::class == javaResource::class

    override fun map(javaResource: Resource): PolicySetDefinitionVersionAtManagementGroup =
        PolicySetDefinitionVersionAtManagementGroup(
            javaResource as
                com.pulumi.azurenative.authorization.PolicySetDefinitionVersionAtManagementGroup,
        )
}

/**
 * @see [PolicySetDefinitionVersionAtManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PolicySetDefinitionVersionAtManagementGroup].
 */
public suspend fun policySetDefinitionVersionAtManagementGroup(
    name: String,
    block: suspend PolicySetDefinitionVersionAtManagementGroupResourceBuilder.() -> Unit,
):
    PolicySetDefinitionVersionAtManagementGroup {
    val builder = PolicySetDefinitionVersionAtManagementGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PolicySetDefinitionVersionAtManagementGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policySetDefinitionVersionAtManagementGroup(name: String):
    PolicySetDefinitionVersionAtManagementGroup {
    val builder = PolicySetDefinitionVersionAtManagementGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
