@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.kotlin.outputs.ResourceManagementPrivateLinkEndpointConnectionsResponse
import com.pulumi.azurenative.authorization.kotlin.outputs.ResourceManagementPrivateLinkEndpointConnectionsResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ResourceManagementPrivateLink].
 */
@PulumiTagMarker
public class ResourceManagementPrivateLinkResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceManagementPrivateLinkArgs = ResourceManagementPrivateLinkArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceManagementPrivateLinkArgsBuilder.() -> Unit) {
        val builder = ResourceManagementPrivateLinkArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceManagementPrivateLink {
        val builtJavaResource =
            com.pulumi.azurenative.authorization.ResourceManagementPrivateLink(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ResourceManagementPrivateLink(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2020-05-01. Prior API version in Azure Native 1.x: 2020-05-01.
 * ## Example Usage
 * ### Create Resource Management Private Link.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceManagementPrivateLink = new AzureNative.Authorization.ResourceManagementPrivateLink("resourceManagementPrivateLink", new()
 *     {
 *         Location = "eastus",
 *         ResourceGroupName = "my-resource-group",
 *         RmplName = "my-rmplName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewResourceManagementPrivateLink(ctx, "resourceManagementPrivateLink", &authorization.ResourceManagementPrivateLinkArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			RmplName:          pulumi.String("my-rmplName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.ResourceManagementPrivateLink;
 * import com.pulumi.azurenative.authorization.ResourceManagementPrivateLinkArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceManagementPrivateLink = new ResourceManagementPrivateLink("resourceManagementPrivateLink", ResourceManagementPrivateLinkArgs.builder()
 *             .location("eastus")
 *             .resourceGroupName("my-resource-group")
 *             .rmplName("my-rmplName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:ResourceManagementPrivateLink my-pla /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Authorization/resourceManagementPrivateLinks/{rmplName}
 * ```
 */
public class ResourceManagementPrivateLink internal constructor(
    override val javaResource: com.pulumi.azurenative.authorization.ResourceManagementPrivateLink,
) : KotlinCustomResource(javaResource, ResourceManagementPrivateLinkMapper) {
    /**
     * the region of the rmpl
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The rmpl Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<ResourceManagementPrivateLinkEndpointConnectionsResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The operation type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ResourceManagementPrivateLinkMapper : ResourceMapper<ResourceManagementPrivateLink> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.authorization.ResourceManagementPrivateLink::class == javaResource::class

    override fun map(javaResource: Resource): ResourceManagementPrivateLink =
        ResourceManagementPrivateLink(
            javaResource as
                com.pulumi.azurenative.authorization.ResourceManagementPrivateLink,
        )
}

/**
 * @see [ResourceManagementPrivateLink].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceManagementPrivateLink].
 */
public suspend fun resourceManagementPrivateLink(
    name: String,
    block: suspend ResourceManagementPrivateLinkResourceBuilder.() -> Unit,
):
    ResourceManagementPrivateLink {
    val builder = ResourceManagementPrivateLinkResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceManagementPrivateLink].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceManagementPrivateLink(name: String): ResourceManagementPrivateLink {
    val builder = ResourceManagementPrivateLinkResourceBuilder()
    builder.name(name)
    return builder.build()
}
