@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.VariableArgs.builder
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyVariableColumnArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyVariableColumnArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The variable.
 * Azure REST API version: 2022-08-01-preview.
 * ## Example Usage
 * ### Create or update a variable
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var variable = new AzureNative.Authorization.Variable("variable", new()
 *     {
 *         Columns = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyVariableColumnArgs
 *             {
 *                 ColumnName = "TestColumn",
 *             },
 *         },
 *         VariableName = "DemoTestVariable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewVariable(ctx, "variable", &authorization.VariableArgs{
 * 			Columns: authorization.PolicyVariableColumnArray{
 * 				&authorization.PolicyVariableColumnArgs{
 * 					ColumnName: pulumi.String("TestColumn"),
 * 				},
 * 			},
 * 			VariableName: pulumi.String("DemoTestVariable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.Variable;
 * import com.pulumi.azurenative.authorization.VariableArgs;
 * import com.pulumi.azurenative.authorization.inputs.PolicyVariableColumnArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var variable = new Variable("variable", VariableArgs.builder()
 *             .columns(PolicyVariableColumnArgs.builder()
 *                 .columnName("TestColumn")
 *                 .build())
 *             .variableName("DemoTestVariable")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:Variable DemoTestVariable /subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}
 * ```
 * @property columns Variable column definitions.
 * @property variableName The name of the variable to operate on.
 */
public data class VariableArgs(
    public val columns: Output<List<PolicyVariableColumnArgs>>? = null,
    public val variableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.VariableArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.VariableArgs =
        com.pulumi.azurenative.authorization.VariableArgs.builder()
            .columns(
                columns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .variableName(variableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VariableArgs].
 */
@PulumiTagMarker
public class VariableArgsBuilder internal constructor() {
    private var columns: Output<List<PolicyVariableColumnArgs>>? = null

    private var variableName: Output<String>? = null

    /**
     * @param value Variable column definitions.
     */
    @JvmName("kcrxwntvqkxnocvq")
    public suspend fun columns(`value`: Output<List<PolicyVariableColumnArgs>>) {
        this.columns = value
    }

    @JvmName("rsapecimpdndkwkq")
    public suspend fun columns(vararg values: Output<PolicyVariableColumnArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values Variable column definitions.
     */
    @JvmName("hdarmhmfbmiyagcc")
    public suspend fun columns(values: List<Output<PolicyVariableColumnArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value The name of the variable to operate on.
     */
    @JvmName("vfegtdfdncvrwrip")
    public suspend fun variableName(`value`: Output<String>) {
        this.variableName = value
    }

    /**
     * @param value Variable column definitions.
     */
    @JvmName("rgxnbtydcpnlvvvr")
    public suspend fun columns(`value`: List<PolicyVariableColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument Variable column definitions.
     */
    @JvmName("rshdxkjodcxrjfnf")
    public suspend fun columns(argument: List<suspend PolicyVariableColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyVariableColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument Variable column definitions.
     */
    @JvmName("wbalrwvxcncfwyrg")
    public suspend fun columns(vararg argument: suspend PolicyVariableColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyVariableColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument Variable column definitions.
     */
    @JvmName("wdekhxpesjhotdyx")
    public suspend fun columns(argument: suspend PolicyVariableColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PolicyVariableColumnArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values Variable column definitions.
     */
    @JvmName("jsuqyjjkavhooudb")
    public suspend fun columns(vararg values: PolicyVariableColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value The name of the variable to operate on.
     */
    @JvmName("rfaxjcljvwkcskna")
    public suspend fun variableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variableName = mapped
    }

    internal fun build(): VariableArgs = VariableArgs(
        columns = columns,
        variableName = variableName,
    )
}
