@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin

import com.pulumi.azurenative.authorization.VariableAtManagementGroupArgs.builder
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyVariableColumnArgs
import com.pulumi.azurenative.authorization.kotlin.inputs.PolicyVariableColumnArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The variable.
 * Azure REST API version: 2022-08-01-preview.
 * ## Example Usage
 * ### Create or update a variable at management group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var variableAtManagementGroup = new AzureNative.Authorization.VariableAtManagementGroup("variableAtManagementGroup", new()
 *     {
 *         Columns = new[]
 *         {
 *             new AzureNative.Authorization.Inputs.PolicyVariableColumnArgs
 *             {
 *                 ColumnName = "TestColumn",
 *             },
 *         },
 *         ManagementGroupId = "DevOrg",
 *         VariableName = "DemoTestVariable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/authorization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := authorization.NewVariableAtManagementGroup(ctx, "variableAtManagementGroup", &authorization.VariableAtManagementGroupArgs{
 * 			Columns: authorization.PolicyVariableColumnArray{
 * 				&authorization.PolicyVariableColumnArgs{
 * 					ColumnName: pulumi.String("TestColumn"),
 * 				},
 * 			},
 * 			ManagementGroupId: pulumi.String("DevOrg"),
 * 			VariableName:      pulumi.String("DemoTestVariable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.authorization.VariableAtManagementGroup;
 * import com.pulumi.azurenative.authorization.VariableAtManagementGroupArgs;
 * import com.pulumi.azurenative.authorization.inputs.PolicyVariableColumnArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var variableAtManagementGroup = new VariableAtManagementGroup("variableAtManagementGroup", VariableAtManagementGroupArgs.builder()
 *             .columns(PolicyVariableColumnArgs.builder()
 *                 .columnName("TestColumn")
 *                 .build())
 *             .managementGroupId("DevOrg")
 *             .variableName("DemoTestVariable")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:authorization:VariableAtManagementGroup DemoTestVariable /providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}
 * ```
 * @property columns Variable column definitions.
 * @property managementGroupId The ID of the management group.
 * @property variableName The name of the variable to operate on.
 */
public data class VariableAtManagementGroupArgs(
    public val columns: Output<List<PolicyVariableColumnArgs>>? = null,
    public val managementGroupId: Output<String>? = null,
    public val variableName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.VariableAtManagementGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.VariableAtManagementGroupArgs =
        com.pulumi.azurenative.authorization.VariableAtManagementGroupArgs.builder()
            .columns(
                columns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .managementGroupId(managementGroupId?.applyValue({ args0 -> args0 }))
            .variableName(variableName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VariableAtManagementGroupArgs].
 */
@PulumiTagMarker
public class VariableAtManagementGroupArgsBuilder internal constructor() {
    private var columns: Output<List<PolicyVariableColumnArgs>>? = null

    private var managementGroupId: Output<String>? = null

    private var variableName: Output<String>? = null

    /**
     * @param value Variable column definitions.
     */
    @JvmName("shjhfbsjwykncvpx")
    public suspend fun columns(`value`: Output<List<PolicyVariableColumnArgs>>) {
        this.columns = value
    }

    @JvmName("fymxgqvmvmqcvqpy")
    public suspend fun columns(vararg values: Output<PolicyVariableColumnArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values Variable column definitions.
     */
    @JvmName("ewblhnhwjwdyckkc")
    public suspend fun columns(values: List<Output<PolicyVariableColumnArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value The ID of the management group.
     */
    @JvmName("xuhknexpelklsinl")
    public suspend fun managementGroupId(`value`: Output<String>) {
        this.managementGroupId = value
    }

    /**
     * @param value The name of the variable to operate on.
     */
    @JvmName("qcbrqnyyrbffrgun")
    public suspend fun variableName(`value`: Output<String>) {
        this.variableName = value
    }

    /**
     * @param value Variable column definitions.
     */
    @JvmName("vjryrsxhcfjgwgad")
    public suspend fun columns(`value`: List<PolicyVariableColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument Variable column definitions.
     */
    @JvmName("incavnomyanmtkio")
    public suspend fun columns(argument: List<suspend PolicyVariableColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyVariableColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument Variable column definitions.
     */
    @JvmName("hkdrkbhkkpumtwsp")
    public suspend fun columns(vararg argument: suspend PolicyVariableColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyVariableColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument Variable column definitions.
     */
    @JvmName("stsiviasyucmeurd")
    public suspend fun columns(argument: suspend PolicyVariableColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PolicyVariableColumnArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values Variable column definitions.
     */
    @JvmName("odbuaiossahqcljj")
    public suspend fun columns(vararg values: PolicyVariableColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value The ID of the management group.
     */
    @JvmName("sxfrxwgqqyqrxegw")
    public suspend fun managementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementGroupId = mapped
    }

    /**
     * @param value The name of the variable to operate on.
     */
    @JvmName("rudtwrmkvgycdxqs")
    public suspend fun variableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.variableName = mapped
    }

    internal fun build(): VariableAtManagementGroupArgs = VariableAtManagementGroupArgs(
        columns = columns,
        managementGroupId = managementGroupId,
        variableName = variableName,
    )
}
