@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.AccessReviewScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Descriptor for what needs to be reviewed
 * @property excludeResourceId This is used to indicate the resource id(s) to exclude
 * @property excludeRoleDefinitionId This is used to indicate the role definition id(s) to exclude
 * @property expandNestedMemberships Flag to indicate whether to expand nested memberships or not.
 * @property inactiveDuration Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
 * @property includeAccessBelowResource Flag to indicate whether to expand nested memberships or not.
 * @property includeInheritedAccess Flag to indicate whether to expand nested memberships or not.
 */
public data class AccessReviewScopeArgs(
    public val excludeResourceId: Output<String>? = null,
    public val excludeRoleDefinitionId: Output<String>? = null,
    public val expandNestedMemberships: Output<Boolean>? = null,
    public val inactiveDuration: Output<String>? = null,
    public val includeAccessBelowResource: Output<Boolean>? = null,
    public val includeInheritedAccess: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.AccessReviewScopeArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.AccessReviewScopeArgs =
        com.pulumi.azurenative.authorization.inputs.AccessReviewScopeArgs.builder()
            .excludeResourceId(excludeResourceId?.applyValue({ args0 -> args0 }))
            .excludeRoleDefinitionId(excludeRoleDefinitionId?.applyValue({ args0 -> args0 }))
            .expandNestedMemberships(expandNestedMemberships?.applyValue({ args0 -> args0 }))
            .inactiveDuration(inactiveDuration?.applyValue({ args0 -> args0 }))
            .includeAccessBelowResource(includeAccessBelowResource?.applyValue({ args0 -> args0 }))
            .includeInheritedAccess(includeInheritedAccess?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessReviewScopeArgs].
 */
@PulumiTagMarker
public class AccessReviewScopeArgsBuilder internal constructor() {
    private var excludeResourceId: Output<String>? = null

    private var excludeRoleDefinitionId: Output<String>? = null

    private var expandNestedMemberships: Output<Boolean>? = null

    private var inactiveDuration: Output<String>? = null

    private var includeAccessBelowResource: Output<Boolean>? = null

    private var includeInheritedAccess: Output<Boolean>? = null

    /**
     * @param value This is used to indicate the resource id(s) to exclude
     */
    @JvmName("dnkcidicqjmeqtch")
    public suspend fun excludeResourceId(`value`: Output<String>) {
        this.excludeResourceId = value
    }

    /**
     * @param value This is used to indicate the role definition id(s) to exclude
     */
    @JvmName("jwhtschtsgiiiost")
    public suspend fun excludeRoleDefinitionId(`value`: Output<String>) {
        this.excludeRoleDefinitionId = value
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("aqbwhsgqoiyurync")
    public suspend fun expandNestedMemberships(`value`: Output<Boolean>) {
        this.expandNestedMemberships = value
    }

    /**
     * @param value Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
     */
    @JvmName("udsawmslinfwcttg")
    public suspend fun inactiveDuration(`value`: Output<String>) {
        this.inactiveDuration = value
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("aukegyqrvgbuaglh")
    public suspend fun includeAccessBelowResource(`value`: Output<Boolean>) {
        this.includeAccessBelowResource = value
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("ddrclkyftyfgciaj")
    public suspend fun includeInheritedAccess(`value`: Output<Boolean>) {
        this.includeInheritedAccess = value
    }

    /**
     * @param value This is used to indicate the resource id(s) to exclude
     */
    @JvmName("abrchbtwgvnjhkcu")
    public suspend fun excludeResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeResourceId = mapped
    }

    /**
     * @param value This is used to indicate the role definition id(s) to exclude
     */
    @JvmName("ybrfilhglitubtqj")
    public suspend fun excludeRoleDefinitionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeRoleDefinitionId = mapped
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("hwwsyodlwvaspril")
    public suspend fun expandNestedMemberships(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expandNestedMemberships = mapped
    }

    /**
     * @param value Duration users are inactive for. The value should be in ISO  8601 format (http://en.wikipedia.org/wiki/ISO_8601#Durations).This code can be used to convert TimeSpan to a valid interval string: XmlConvert.ToString(new TimeSpan(hours, minutes, seconds))
     */
    @JvmName("egthimlbmrlvjgfu")
    public suspend fun inactiveDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inactiveDuration = mapped
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("hhwivxjchxpffvle")
    public suspend fun includeAccessBelowResource(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeAccessBelowResource = mapped
    }

    /**
     * @param value Flag to indicate whether to expand nested memberships or not.
     */
    @JvmName("xrtsishxpgtkjsfl")
    public suspend fun includeInheritedAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeInheritedAccess = mapped
    }

    internal fun build(): AccessReviewScopeArgs = AccessReviewScopeArgs(
        excludeResourceId = excludeResourceId,
        excludeRoleDefinitionId = excludeRoleDefinitionId,
        expandNestedMemberships = expandNestedMemberships,
        inactiveDuration = inactiveDuration,
        includeAccessBelowResource = includeAccessBelowResource,
        includeInheritedAccess = includeInheritedAccess,
    )
}
