@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetAccessReviewHistoryDefinitionByIdPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property historyDefinitionId The id of the access review history definition.
 */
public data class GetAccessReviewHistoryDefinitionByIdPlainArgs(
    public val historyDefinitionId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetAccessReviewHistoryDefinitionByIdPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetAccessReviewHistoryDefinitionByIdPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetAccessReviewHistoryDefinitionByIdPlainArgs.builder()
            .historyDefinitionId(historyDefinitionId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessReviewHistoryDefinitionByIdPlainArgs].
 */
@PulumiTagMarker
public class GetAccessReviewHistoryDefinitionByIdPlainArgsBuilder internal constructor() {
    private var historyDefinitionId: String? = null

    /**
     * @param value The id of the access review history definition.
     */
    @JvmName("ydvcgbrnvdbhjdbq")
    public suspend fun historyDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.historyDefinitionId = mapped
    }

    internal fun build(): GetAccessReviewHistoryDefinitionByIdPlainArgs =
        GetAccessReviewHistoryDefinitionByIdPlainArgs(
            historyDefinitionId = historyDefinitionId ?: throw PulumiNullFieldException("historyDefinitionId"),
        )
}
