@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetAccessReviewScheduleDefinitionByIdPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property scheduleDefinitionId The id of the access review schedule definition.
 */
public data class GetAccessReviewScheduleDefinitionByIdPlainArgs(
    public val scheduleDefinitionId: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetAccessReviewScheduleDefinitionByIdPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetAccessReviewScheduleDefinitionByIdPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetAccessReviewScheduleDefinitionByIdPlainArgs.builder()
            .scheduleDefinitionId(scheduleDefinitionId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessReviewScheduleDefinitionByIdPlainArgs].
 */
@PulumiTagMarker
public class GetAccessReviewScheduleDefinitionByIdPlainArgsBuilder internal constructor() {
    private var scheduleDefinitionId: String? = null

    /**
     * @param value The id of the access review schedule definition.
     */
    @JvmName("cfqmnajuhoavuydk")
    public suspend fun scheduleDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scheduleDefinitionId = mapped
    }

    internal fun build(): GetAccessReviewScheduleDefinitionByIdPlainArgs =
        GetAccessReviewScheduleDefinitionByIdPlainArgs(
            scheduleDefinitionId = scheduleDefinitionId ?: throw
                PulumiNullFieldException("scheduleDefinitionId"),
        )
}
