@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetManagementLockAtSubscriptionLevelPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lockName The name of the lock to get.
 */
public data class GetManagementLockAtSubscriptionLevelPlainArgs(
    public val lockName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetManagementLockAtSubscriptionLevelPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetManagementLockAtSubscriptionLevelPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetManagementLockAtSubscriptionLevelPlainArgs.builder()
            .lockName(lockName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagementLockAtSubscriptionLevelPlainArgs].
 */
@PulumiTagMarker
public class GetManagementLockAtSubscriptionLevelPlainArgsBuilder internal constructor() {
    private var lockName: String? = null

    /**
     * @param value The name of the lock to get.
     */
    @JvmName("drijfgtyvsngfiam")
    public suspend fun lockName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.lockName = mapped
    }

    internal fun build(): GetManagementLockAtSubscriptionLevelPlainArgs =
        GetManagementLockAtSubscriptionLevelPlainArgs(
            lockName = lockName ?: throw PulumiNullFieldException("lockName"),
        )
}
