@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionVersionAtManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupName The name of the management group. The name is case insensitive.
 * @property policyDefinitionName The name of the policy definition.
 * @property policyDefinitionVersion The policy definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
 */
public data class GetPolicyDefinitionVersionAtManagementGroupPlainArgs(
    public val managementGroupName: String,
    public val policyDefinitionName: String,
    public val policyDefinitionVersion: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionVersionAtManagementGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionVersionAtManagementGroupPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetPolicyDefinitionVersionAtManagementGroupPlainArgs.builder()
            .managementGroupName(managementGroupName.let({ args0 -> args0 }))
            .policyDefinitionName(policyDefinitionName.let({ args0 -> args0 }))
            .policyDefinitionVersion(policyDefinitionVersion.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicyDefinitionVersionAtManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class GetPolicyDefinitionVersionAtManagementGroupPlainArgsBuilder internal constructor() {
    private var managementGroupName: String? = null

    private var policyDefinitionName: String? = null

    private var policyDefinitionVersion: String? = null

    /**
     * @param value The name of the management group. The name is case insensitive.
     */
    @JvmName("jdsmmuymbjbnnhpm")
    public suspend fun managementGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupName = mapped
    }

    /**
     * @param value The name of the policy definition.
     */
    @JvmName("kddkgqxsirrbmooi")
    public suspend fun policyDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyDefinitionName = mapped
    }

    /**
     * @param value The policy definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     */
    @JvmName("hdxjeffbsnrqbflf")
    public suspend fun policyDefinitionVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyDefinitionVersion = mapped
    }

    internal fun build(): GetPolicyDefinitionVersionAtManagementGroupPlainArgs =
        GetPolicyDefinitionVersionAtManagementGroupPlainArgs(
            managementGroupName = managementGroupName ?: throw PulumiNullFieldException("managementGroupName"),
            policyDefinitionName = policyDefinitionName ?: throw
                PulumiNullFieldException("policyDefinitionName"),
            policyDefinitionVersion = policyDefinitionVersion ?: throw
                PulumiNullFieldException("policyDefinitionVersion"),
        )
}
