@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionVersionAtManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupName The name of the management group. The name is case insensitive.
 * @property policyDefinitionVersion The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
 * @property policySetDefinitionName The name of the policy set definition.
 */
public data class GetPolicySetDefinitionVersionAtManagementGroupPlainArgs(
    public val managementGroupName: String,
    public val policyDefinitionVersion: String,
    public val policySetDefinitionName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionVersionAtManagementGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionVersionAtManagementGroupPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetPolicySetDefinitionVersionAtManagementGroupPlainArgs.builder()
            .managementGroupName(managementGroupName.let({ args0 -> args0 }))
            .policyDefinitionVersion(policyDefinitionVersion.let({ args0 -> args0 }))
            .policySetDefinitionName(policySetDefinitionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPolicySetDefinitionVersionAtManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class GetPolicySetDefinitionVersionAtManagementGroupPlainArgsBuilder internal constructor() {
    private var managementGroupName: String? = null

    private var policyDefinitionVersion: String? = null

    private var policySetDefinitionName: String? = null

    /**
     * @param value The name of the management group. The name is case insensitive.
     */
    @JvmName("fqkrfeudunpidyhg")
    public suspend fun managementGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupName = mapped
    }

    /**
     * @param value The policy set definition version.  The format is x.y.z where x is the major version number, y is the minor version number, and z is the patch number
     */
    @JvmName("ydcdasakxkqiixvb")
    public suspend fun policyDefinitionVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policyDefinitionVersion = mapped
    }

    /**
     * @param value The name of the policy set definition.
     */
    @JvmName("qoqcoqqetrhgpmhx")
    public suspend fun policySetDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.policySetDefinitionName = mapped
    }

    internal fun build(): GetPolicySetDefinitionVersionAtManagementGroupPlainArgs =
        GetPolicySetDefinitionVersionAtManagementGroupPlainArgs(
            managementGroupName = managementGroupName ?: throw PulumiNullFieldException("managementGroupName"),
            policyDefinitionVersion = policyDefinitionVersion ?: throw
                PulumiNullFieldException("policyDefinitionVersion"),
            policySetDefinitionName = policySetDefinitionName ?: throw
                PulumiNullFieldException("policySetDefinitionName"),
        )
}
