@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetRoleDefinitionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property roleDefinitionId The ID of the role definition.
 * @property scope The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
 */
public data class GetRoleDefinitionPlainArgs(
    public val roleDefinitionId: String,
    public val scope: String,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetRoleDefinitionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.GetRoleDefinitionPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetRoleDefinitionPlainArgs.builder()
            .roleDefinitionId(roleDefinitionId.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRoleDefinitionPlainArgs].
 */
@PulumiTagMarker
public class GetRoleDefinitionPlainArgsBuilder internal constructor() {
    private var roleDefinitionId: String? = null

    private var scope: String? = null

    /**
     * @param value The ID of the role definition.
     */
    @JvmName("ejunqbbrgojjkkgr")
    public suspend fun roleDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.roleDefinitionId = mapped
    }

    /**
     * @param value The scope of the operation or resource. Valid scopes are: subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}', or resource (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/[{parentResourcePath}/]{resourceType}/{resourceName}'
     */
    @JvmName("prkksvenntgwpiam")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetRoleDefinitionPlainArgs = GetRoleDefinitionPlainArgs(
        roleDefinitionId = roleDefinitionId ?: throw PulumiNullFieldException("roleDefinitionId"),
        scope = scope ?: throw PulumiNullFieldException("scope"),
    )
}
