@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetScopeAccessReviewHistoryDefinitionByIdPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property historyDefinitionId The id of the access review history definition.
 * @property scope The scope of the resource.
 */
public data class GetScopeAccessReviewHistoryDefinitionByIdPlainArgs(
    public val historyDefinitionId: String,
    public val scope: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetScopeAccessReviewHistoryDefinitionByIdPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetScopeAccessReviewHistoryDefinitionByIdPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetScopeAccessReviewHistoryDefinitionByIdPlainArgs.builder()
            .historyDefinitionId(historyDefinitionId.let({ args0 -> args0 }))
            .scope(scope.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetScopeAccessReviewHistoryDefinitionByIdPlainArgs].
 */
@PulumiTagMarker
public class GetScopeAccessReviewHistoryDefinitionByIdPlainArgsBuilder internal constructor() {
    private var historyDefinitionId: String? = null

    private var scope: String? = null

    /**
     * @param value The id of the access review history definition.
     */
    @JvmName("arqupqhufhhvaqdh")
    public suspend fun historyDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.historyDefinitionId = mapped
    }

    /**
     * @param value The scope of the resource.
     */
    @JvmName("bvmidaqtdxrsxsqa")
    public suspend fun scope(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.scope = mapped
    }

    internal fun build(): GetScopeAccessReviewHistoryDefinitionByIdPlainArgs =
        GetScopeAccessReviewHistoryDefinitionByIdPlainArgs(
            historyDefinitionId = historyDefinitionId ?: throw PulumiNullFieldException("historyDefinitionId"),
            scope = scope ?: throw PulumiNullFieldException("scope"),
        )
}
