@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.GetVariableValueAtManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupId The ID of the management group.
 * @property variableName The name of the variable to operate on.
 * @property variableValueName The name of the variable value to operate on.
 */
public data class GetVariableValueAtManagementGroupPlainArgs(
    public val managementGroupId: String,
    public val variableName: String,
    public val variableValueName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.GetVariableValueAtManagementGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.GetVariableValueAtManagementGroupPlainArgs =
        com.pulumi.azurenative.authorization.inputs.GetVariableValueAtManagementGroupPlainArgs.builder()
            .managementGroupId(managementGroupId.let({ args0 -> args0 }))
            .variableName(variableName.let({ args0 -> args0 }))
            .variableValueName(variableValueName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVariableValueAtManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class GetVariableValueAtManagementGroupPlainArgsBuilder internal constructor() {
    private var managementGroupId: String? = null

    private var variableName: String? = null

    private var variableValueName: String? = null

    /**
     * @param value The ID of the management group.
     */
    @JvmName("lrfcbpapiamxfnxw")
    public suspend fun managementGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupId = mapped
    }

    /**
     * @param value The name of the variable to operate on.
     */
    @JvmName("jtropmentlgceerp")
    public suspend fun variableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.variableName = mapped
    }

    /**
     * @param value The name of the variable value to operate on.
     */
    @JvmName("shbqxbiagdiiajxs")
    public suspend fun variableValueName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.variableValueName = mapped
    }

    internal fun build(): GetVariableValueAtManagementGroupPlainArgs =
        GetVariableValueAtManagementGroupPlainArgs(
            managementGroupId = managementGroupId ?: throw PulumiNullFieldException("managementGroupId"),
            variableName = variableName ?: throw PulumiNullFieldException("variableName"),
            variableValueName = variableValueName ?: throw PulumiNullFieldException("variableValueName"),
        )
}
