@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.IdentityArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Identity for the resource.  Policy assignments support a maximum of one identity.  That is either a system assigned identity or a single user assigned identity.
 * @property type The identity type. This is the only required field when adding a system or user assigned identity to a resource.
 * @property userAssignedIdentities The user identity associated with the policy. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class IdentityArgs(
    public val type: Output<ResourceIdentityType>? = null,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.IdentityArgs =
        com.pulumi.azurenative.authorization.inputs.IdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The identity type. This is the only required field when adding a system or user assigned identity to a resource.
     */
    @JvmName("tcdgjruavqvxrivk")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The user identity associated with the policy. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("bddisbvmvlebijhl")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("iapulwqdhiifmdym")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values The user identity associated with the policy. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("onmvhpvkuepxqwna")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The identity type. This is the only required field when adding a system or user assigned identity to a resource.
     */
    @JvmName("kylwhcpvsduvpoma")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The user identity associated with the policy. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("pdnycaxlmrvbkxrs")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values The user identity associated with the policy. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    @JvmName("vaxpnoottknkkqmb")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        type = type,
        userAssignedIdentities = userAssignedIdentities,
    )
}
