@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property managementGroupName The name of the management group. The name is case insensitive.
 */
public data class ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs(
    public val managementGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs =
        com.pulumi.azurenative.authorization.inputs.ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs.builder()
            .managementGroupName(managementGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs].
 */
@PulumiTagMarker
public class ListPolicyDefinitionVersionAllAtManagementGroupPlainArgsBuilder internal constructor() {
    private var managementGroupName: String? = null

    /**
     * @param value The name of the management group. The name is case insensitive.
     */
    @JvmName("fycjhjuspfmrrkvu")
    public suspend fun managementGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managementGroupName = mapped
    }

    internal fun build(): ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs =
        ListPolicyDefinitionVersionAllAtManagementGroupPlainArgs(
            managementGroupName = managementGroupName ?: throw PulumiNullFieldException("managementGroupName"),
        )
}
