@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.PermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Role definition permissions.
 * @property actions Allowed actions.
 * @property dataActions Allowed Data actions.
 * @property notActions Denied actions.
 * @property notDataActions Denied Data actions.
 */
public data class PermissionArgs(
    public val actions: Output<List<String>>? = null,
    public val dataActions: Output<List<String>>? = null,
    public val notActions: Output<List<String>>? = null,
    public val notDataActions: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.PermissionArgs> {
    override fun toJava(): com.pulumi.azurenative.authorization.inputs.PermissionArgs =
        com.pulumi.azurenative.authorization.inputs.PermissionArgs.builder()
            .actions(actions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dataActions(dataActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notActions(notActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notDataActions(notDataActions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [PermissionArgs].
 */
@PulumiTagMarker
public class PermissionArgsBuilder internal constructor() {
    private var actions: Output<List<String>>? = null

    private var dataActions: Output<List<String>>? = null

    private var notActions: Output<List<String>>? = null

    private var notDataActions: Output<List<String>>? = null

    /**
     * @param value Allowed actions.
     */
    @JvmName("vqtgrwwpirjaqgkm")
    public suspend fun actions(`value`: Output<List<String>>) {
        this.actions = value
    }

    @JvmName("lcnnqpyopsbkngeg")
    public suspend fun actions(vararg values: Output<String>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values Allowed actions.
     */
    @JvmName("hltnykcghrgovkgv")
    public suspend fun actions(values: List<Output<String>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value Allowed Data actions.
     */
    @JvmName("dwrikbobgayxlsqx")
    public suspend fun dataActions(`value`: Output<List<String>>) {
        this.dataActions = value
    }

    @JvmName("htvquhdwqkdemtux")
    public suspend fun dataActions(vararg values: Output<String>) {
        this.dataActions = Output.all(values.asList())
    }

    /**
     * @param values Allowed Data actions.
     */
    @JvmName("jblssxqigtsvtnjn")
    public suspend fun dataActions(values: List<Output<String>>) {
        this.dataActions = Output.all(values)
    }

    /**
     * @param value Denied actions.
     */
    @JvmName("hiuomotoxllguycv")
    public suspend fun notActions(`value`: Output<List<String>>) {
        this.notActions = value
    }

    @JvmName("mfseeqxkjigwkqyv")
    public suspend fun notActions(vararg values: Output<String>) {
        this.notActions = Output.all(values.asList())
    }

    /**
     * @param values Denied actions.
     */
    @JvmName("rlpaabeduekyyvyv")
    public suspend fun notActions(values: List<Output<String>>) {
        this.notActions = Output.all(values)
    }

    /**
     * @param value Denied Data actions.
     */
    @JvmName("wktgrschcqxbsiut")
    public suspend fun notDataActions(`value`: Output<List<String>>) {
        this.notDataActions = value
    }

    @JvmName("kgxagajhvqsdxnjc")
    public suspend fun notDataActions(vararg values: Output<String>) {
        this.notDataActions = Output.all(values.asList())
    }

    /**
     * @param values Denied Data actions.
     */
    @JvmName("ejijvaetxtrakgfl")
    public suspend fun notDataActions(values: List<Output<String>>) {
        this.notDataActions = Output.all(values)
    }

    /**
     * @param value Allowed actions.
     */
    @JvmName("yshmswmdevxadakc")
    public suspend fun actions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values Allowed actions.
     */
    @JvmName("ndbflkrdcdhaslqb")
    public suspend fun actions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value Allowed Data actions.
     */
    @JvmName("hqbyfulgamdgmllq")
    public suspend fun dataActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataActions = mapped
    }

    /**
     * @param values Allowed Data actions.
     */
    @JvmName("bseidovqvtnmybhj")
    public suspend fun dataActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataActions = mapped
    }

    /**
     * @param value Denied actions.
     */
    @JvmName("orecveigjkhfhcih")
    public suspend fun notActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notActions = mapped
    }

    /**
     * @param values Denied actions.
     */
    @JvmName("drostasywxahuhqk")
    public suspend fun notActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notActions = mapped
    }

    /**
     * @param value Denied Data actions.
     */
    @JvmName("qqfesoqtdikueonw")
    public suspend fun notDataActions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notDataActions = mapped
    }

    /**
     * @param values Denied Data actions.
     */
    @JvmName("vrtwqepaprnbfjpl")
    public suspend fun notDataActions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notDataActions = mapped
    }

    internal fun build(): PermissionArgs = PermissionArgs(
        actions = actions,
        dataActions = dataActions,
        notActions = notActions,
        notDataActions = notDataActions,
    )
}
