@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.inputs

import com.pulumi.azurenative.authorization.inputs.PrivateLinkAssociationPropertiesArgs.builder
import com.pulumi.azurenative.authorization.kotlin.enums.PublicNetworkAccessOptions
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateLink The rmpl Resource ID.
 * @property publicNetworkAccess
 */
public data class PrivateLinkAssociationPropertiesArgs(
    public val privateLink: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccessOptions>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.authorization.inputs.PrivateLinkAssociationPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.authorization.inputs.PrivateLinkAssociationPropertiesArgs =
        com.pulumi.azurenative.authorization.inputs.PrivateLinkAssociationPropertiesArgs.builder()
            .privateLink(privateLink?.applyValue({ args0 -> args0 }))
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkAssociationPropertiesArgs].
 */
@PulumiTagMarker
public class PrivateLinkAssociationPropertiesArgsBuilder internal constructor() {
    private var privateLink: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccessOptions>>? = null

    /**
     * @param value The rmpl Resource ID.
     */
    @JvmName("obpragfcrvpslllk")
    public suspend fun privateLink(`value`: Output<String>) {
        this.privateLink = value
    }

    /**
     * @param value
     */
    @JvmName("tqiudhwslhcqtbel")
    public suspend
    fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccessOptions>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The rmpl Resource ID.
     */
    @JvmName("kgqclsvslamamdet")
    public suspend fun privateLink(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLink = mapped
    }

    /**
     * @param value
     */
    @JvmName("ohkqkhhqxraucfsi")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccessOptions>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value
     */
    @JvmName("jwptshpvrfskilmw")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value
     */
    @JvmName("eygbofympiplkctw")
    public fun publicNetworkAccess(`value`: PublicNetworkAccessOptions) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessOptions>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    internal fun build(): PrivateLinkAssociationPropertiesArgs = PrivateLinkAssociationPropertiesArgs(
        privateLink = privateLink,
        publicNetworkAccess = publicNetworkAccess,
    )
}
