@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * The approval stage.
 * @property approvalStageTimeOutInDays The time in days when approval request would be timed out
 * @property escalationApprovers The escalation approver of the request.
 * @property escalationTimeInMinutes The time in minutes when the approval request would be escalated if the primary approver does not approve
 * @property isApproverJustificationRequired Determines whether approver need to provide justification for his decision.
 * @property isEscalationEnabled The value determine whether escalation feature is enabled.
 * @property primaryApprovers The primary approver of the request.
 */
public data class ApprovalStageResponse(
    public val approvalStageTimeOutInDays: Int? = null,
    public val escalationApprovers: List<UserSetResponse>? = null,
    public val escalationTimeInMinutes: Int? = null,
    public val isApproverJustificationRequired: Boolean? = null,
    public val isEscalationEnabled: Boolean? = null,
    public val primaryApprovers: List<UserSetResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.ApprovalStageResponse):
            ApprovalStageResponse = ApprovalStageResponse(
            approvalStageTimeOutInDays = javaType.approvalStageTimeOutInDays().map({ args0 ->
                args0
            }).orElse(null),
            escalationApprovers = javaType.escalationApprovers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.UserSetResponse.Companion.toKotlin(args0)
                })
            }),
            escalationTimeInMinutes = javaType.escalationTimeInMinutes().map({ args0 -> args0 }).orElse(null),
            isApproverJustificationRequired = javaType.isApproverJustificationRequired().map({ args0 ->
                args0
            }).orElse(null),
            isEscalationEnabled = javaType.isEscalationEnabled().map({ args0 -> args0 }).orElse(null),
            primaryApprovers = javaType.primaryApprovers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.UserSetResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
