@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The lock information.
 * @property id The resource ID of the lock.
 * @property level The level of the lock. Possible values are: NotSpecified, CanNotDelete, ReadOnly. CanNotDelete means authorized users are able to read and modify the resources, but not delete. ReadOnly means authorized users can only read from a resource, but they can't modify or delete it.
 * @property name The name of the lock.
 * @property notes Notes about the lock. Maximum of 512 characters.
 * @property owners The owners of the lock.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The resource type of the lock - Microsoft.Authorization/locks.
 */
public data class GetManagementLockByScopeResult(
    public val id: String,
    public val level: String,
    public val name: String,
    public val notes: String? = null,
    public val owners: List<ManagementLockOwnerResponse>? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetManagementLockByScopeResult):
            GetManagementLockByScopeResult = GetManagementLockByScopeResult(
            id = javaType.id(),
            level = javaType.level(),
            name = javaType.name(),
            notes = javaType.notes().map({ args0 -> args0 }).orElse(null),
            owners = javaType.owners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.ManagementLockOwnerResponse.Companion.toKotlin(args0)
                })
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.authorization.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
