@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id The rmplResourceID.
 * @property location the region of the rmpl
 * @property name The rmpl Name.
 * @property properties
 * @property type The operation type.
 */
public data class GetResourceManagementPrivateLinkResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: ResourceManagementPrivateLinkEndpointConnectionsResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.GetResourceManagementPrivateLinkResult):
            GetResourceManagementPrivateLinkResult = GetResourceManagementPrivateLinkResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.authorization.kotlin.outputs.ResourceManagementPrivateLinkEndpointConnectionsResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
