@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The policy property value override.
 * @property kind The override kind.
 * @property selectors The list of the selector expressions.
 * @property value The value to override the policy property.
 */
public data class OverrideResponse(
    public val kind: String? = null,
    public val selectors: List<SelectorResponse>? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.OverrideResponse):
            OverrideResponse = OverrideResponse(
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            selectors = javaType.selectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.SelectorResponse.Companion.toKotlin(args0)
                })
            }),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
