@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * General metadata for the parameter.
 * @property assignPermissions Set to true to have Azure portal create role assignments on the resource ID or resource scope value of this parameter during policy assignment. This property is useful in case you wish to assign permissions outside the assignment scope.
 * @property description The description of the parameter.
 * @property displayName The display name for the parameter.
 * @property strongType Used when assigning the policy definition through the portal. Provides a context aware list of values for the user to choose from.
 */
public data class ParameterDefinitionsValueResponseMetadata(
    public val assignPermissions: Boolean? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val strongType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.ParameterDefinitionsValueResponseMetadata):
            ParameterDefinitionsValueResponseMetadata = ParameterDefinitionsValueResponseMetadata(
            assignPermissions = javaType.assignPermissions().map({ args0 -> args0 }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            strongType = javaType.strongType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
