@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.Suppress

/**
 * Expanded info of resource scope, role definition and policy
 * @property policy Details of the policy
 * @property roleDefinition Details of role definition
 * @property scope Details of the resource scope
 */
public data class PolicyAssignmentPropertiesResponse(
    public val policy: PolicyAssignmentPropertiesResponsePolicy? = null,
    public val roleDefinition: PolicyAssignmentPropertiesResponseRoleDefinition? = null,
    public val scope: PolicyAssignmentPropertiesResponseScope? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.PolicyAssignmentPropertiesResponse):
            PolicyAssignmentPropertiesResponse = PolicyAssignmentPropertiesResponse(
            policy = javaType.policy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.PolicyAssignmentPropertiesResponsePolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            roleDefinition = javaType.roleDefinition().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.PolicyAssignmentPropertiesResponseRoleDefinition.Companion.toKotlin(args0)
                })
            }).orElse(null),
            scope = javaType.scope().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.PolicyAssignmentPropertiesResponseScope.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
