@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.authorization.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The resource selector to filter policies by resource properties.
 * @property name The name of the resource selector.
 * @property selectors The list of the selector expressions.
 */
public data class ResourceSelectorResponse(
    public val name: String? = null,
    public val selectors: List<SelectorResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.authorization.outputs.ResourceSelectorResponse):
            ResourceSelectorResponse = ResourceSelectorResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            selectors = javaType.selectors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.authorization.kotlin.outputs.SelectorResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
